package fr.inra.agrosyst.api.entities.action;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedMineralProductInputTopiaDao<E extends MineralProductInput> extends AbstractAbstractInputTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) MineralProductInput.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.MineralProductInput;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(AgrosystInterventionType inputType) {
        return create(MineralProductInput.PROPERTY_INPUT_TYPE, inputType);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhytoEffectIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MineralProductInput.PROPERTY_PHYTO_EFFECT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPhytoEffectEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MineralProductInput.PROPERTY_PHYTO_EFFECT, v);
        return result;
    }

    @Deprecated
    public E findByPhytoEffect(boolean v) {
        return forPhytoEffectEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPhytoEffect(boolean v) {
        return forPhytoEffectEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMineralProductIn(Collection<RefFertiMinUNIFA> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MineralProductInput.PROPERTY_MINERAL_PRODUCT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMineralProductEquals(RefFertiMinUNIFA v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MineralProductInput.PROPERTY_MINERAL_PRODUCT, v);
        return result;
    }

    @Deprecated
    public E findByMineralProduct(RefFertiMinUNIFA v) {
        return forMineralProductEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMineralProduct(RefFertiMinUNIFA v) {
        return forMineralProductEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMineralProductUnitIn(Collection<MineralProductUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MineralProductInput.PROPERTY_MINERAL_PRODUCT_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMineralProductUnitEquals(MineralProductUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MineralProductInput.PROPERTY_MINERAL_PRODUCT_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByMineralProductUnit(MineralProductUnit v) {
        return forMineralProductUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMineralProductUnit(MineralProductUnit v) {
        return forMineralProductUnitEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMineralFertilizersSpreadingActionIn(Collection<MineralFertilizersSpreadingAction> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(MineralProductInput.PROPERTY_MINERAL_FERTILIZERS_SPREADING_ACTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMineralFertilizersSpreadingActionEquals(MineralFertilizersSpreadingAction v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(MineralProductInput.PROPERTY_MINERAL_FERTILIZERS_SPREADING_ACTION, v);
        return result;
    }

    @Deprecated
    public E findByMineralFertilizersSpreadingAction(MineralFertilizersSpreadingAction v) {
        return forMineralFertilizersSpreadingActionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMineralFertilizersSpreadingAction(MineralFertilizersSpreadingAction v) {
        return forMineralFertilizersSpreadingActionEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedMineralProductInputTopiaDao<E extends MineralProductInput>
