package fr.inra.agrosyst.api.entities.action;

import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedIrrigationActionTopiaDao<E extends IrrigationAction> extends AbstractAbstractActionTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) IrrigationAction.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.IrrigationAction;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            OtherProductInputTopiaDao dao = topiaDaoSupplier
                    .getDao(OtherProductInput.class, OtherProductInputTopiaDao.class);
            List<OtherProductInput> list = dao
                    .forProperties(OtherProductInput.PROPERTY_IRRIGATION_ACTION, entity)
                    .findAll();
            for (OtherProductInput item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getIrrigationAction())) {
                    item.setIrrigationAction(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(RefInterventionAgrosystTravailEDI mainAction) {
        return create(IrrigationAction.PROPERTY_MAIN_ACTION, mainAction);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaterQuantityMinIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(IrrigationAction.PROPERTY_WATER_QUANTITY_MIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaterQuantityMinEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(IrrigationAction.PROPERTY_WATER_QUANTITY_MIN, v);
        return result;
    }

    @Deprecated
    public E findByWaterQuantityMin(Double v) {
        return forWaterQuantityMinEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWaterQuantityMin(Double v) {
        return forWaterQuantityMinEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaterQuantityMaxIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(IrrigationAction.PROPERTY_WATER_QUANTITY_MAX, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaterQuantityMaxEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(IrrigationAction.PROPERTY_WATER_QUANTITY_MAX, v);
        return result;
    }

    @Deprecated
    public E findByWaterQuantityMax(Double v) {
        return forWaterQuantityMaxEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWaterQuantityMax(Double v) {
        return forWaterQuantityMaxEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaterQuantityAverageIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(IrrigationAction.PROPERTY_WATER_QUANTITY_AVERAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaterQuantityAverageEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(IrrigationAction.PROPERTY_WATER_QUANTITY_AVERAGE, v);
        return result;
    }

    @Deprecated
    public E findByWaterQuantityAverage(double v) {
        return forWaterQuantityAverageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWaterQuantityAverage(double v) {
        return forWaterQuantityAverageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaterQuantityMedianIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(IrrigationAction.PROPERTY_WATER_QUANTITY_MEDIAN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWaterQuantityMedianEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(IrrigationAction.PROPERTY_WATER_QUANTITY_MEDIAN, v);
        return result;
    }

    @Deprecated
    public E findByWaterQuantityMedian(Double v) {
        return forWaterQuantityMedianEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWaterQuantityMedian(Double v) {
        return forWaterQuantityMedianEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAzoteQuantityIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(IrrigationAction.PROPERTY_AZOTE_QUANTITY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAzoteQuantityEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(IrrigationAction.PROPERTY_AZOTE_QUANTITY, v);
        return result;
    }

    @Deprecated
    public E findByAzoteQuantity(Integer v) {
        return forAzoteQuantityEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAzoteQuantity(Integer v) {
        return forAzoteQuantityEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == OtherProductInput.class) {
            OtherProductInputTopiaDao dao =
                topiaDaoSupplier.getDao(OtherProductInput.class, OtherProductInputTopiaDao.class);
            tmp = dao.forIrrigationActionEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(OtherProductInput.class, entity);
        if (!list.isEmpty()) {
            result.put(OtherProductInput.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedIrrigationActionTopiaDao<E extends IrrigationAction>
