package fr.inra.agrosyst.api.entities.action;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedAbstractInputTopiaDao<E extends AbstractInput> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) AbstractInput.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.AbstractInput;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(AgrosystInterventionType inputType) {
        return create(AbstractInput.PROPERTY_INPUT_TYPE, inputType);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQtMinIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractInput.PROPERTY_QT_MIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQtMinEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractInput.PROPERTY_QT_MIN, v);
        return result;
    }

    @Deprecated
    public E findByQtMin(Double v) {
        return forQtMinEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByQtMin(Double v) {
        return forQtMinEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQtAvgIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractInput.PROPERTY_QT_AVG, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQtAvgEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractInput.PROPERTY_QT_AVG, v);
        return result;
    }

    @Deprecated
    public E findByQtAvg(Double v) {
        return forQtAvgEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByQtAvg(Double v) {
        return forQtAvgEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQtMedIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractInput.PROPERTY_QT_MED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQtMedEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractInput.PROPERTY_QT_MED, v);
        return result;
    }

    @Deprecated
    public E findByQtMed(Double v) {
        return forQtMedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByQtMed(Double v) {
        return forQtMedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQtMaxIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractInput.PROPERTY_QT_MAX, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forQtMaxEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractInput.PROPERTY_QT_MAX, v);
        return result;
    }

    @Deprecated
    public E findByQtMax(Double v) {
        return forQtMaxEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByQtMax(Double v) {
        return forQtMaxEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProductNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractInput.PROPERTY_PRODUCT_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProductNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractInput.PROPERTY_PRODUCT_NAME, v);
        return result;
    }

    @Deprecated
    public E findByProductName(String v) {
        return forProductNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByProductName(String v) {
        return forProductNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInputTypeIn(Collection<AgrosystInterventionType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractInput.PROPERTY_INPUT_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forInputTypeEquals(AgrosystInterventionType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractInput.PROPERTY_INPUT_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByInputType(AgrosystInterventionType v) {
        return forInputTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByInputType(AgrosystInterventionType v) {
        return forInputTypeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAbstractInputTopiaDao<E extends AbstractInput>
