package fr.inra.agrosyst.api.entities.action;

import fr.inra.agrosyst.api.entities.AbstractAgrosystTopiaDao;
import fr.inra.agrosyst.api.entities.AgrosystEntityEnum;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedAbstractActionTopiaDao<E extends AbstractAction> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) AbstractAction.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.AbstractAction;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(RefInterventionAgrosystTravailEDI mainAction) {
        return create(AbstractAction.PROPERTY_MAIN_ACTION, mainAction);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractAction.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractAction.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forToolsCouplingCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractAction.PROPERTY_TOOLS_COUPLING_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forToolsCouplingCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractAction.PROPERTY_TOOLS_COUPLING_CODE, v);
        return result;
    }

    @Deprecated
    public E findByToolsCouplingCode(String v) {
        return forToolsCouplingCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByToolsCouplingCode(String v) {
        return forToolsCouplingCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedInterventionIn(Collection<PracticedIntervention> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractAction.PROPERTY_PRACTICED_INTERVENTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPracticedInterventionEquals(PracticedIntervention v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractAction.PROPERTY_PRACTICED_INTERVENTION, v);
        return result;
    }

    @Deprecated
    public E findByPracticedIntervention(PracticedIntervention v) {
        return forPracticedInterventionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPracticedIntervention(PracticedIntervention v) {
        return forPracticedInterventionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEffectiveInterventionIn(Collection<EffectiveIntervention> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractAction.PROPERTY_EFFECTIVE_INTERVENTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEffectiveInterventionEquals(EffectiveIntervention v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractAction.PROPERTY_EFFECTIVE_INTERVENTION, v);
        return result;
    }

    @Deprecated
    public E findByEffectiveIntervention(EffectiveIntervention v) {
        return forEffectiveInterventionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEffectiveIntervention(EffectiveIntervention v) {
        return forEffectiveInterventionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMainActionIn(Collection<RefInterventionAgrosystTravailEDI> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AbstractAction.PROPERTY_MAIN_ACTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMainActionEquals(RefInterventionAgrosystTravailEDI v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AbstractAction.PROPERTY_MAIN_ACTION, v);
        return result;
    }

    @Deprecated
    public E findByMainAction(RefInterventionAgrosystTravailEDI v) {
        return forMainActionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMainAction(RefInterventionAgrosystTravailEDI v) {
        return forMainActionEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAbstractActionTopiaDao<E extends AbstractAction>
