package fr.inra.agrosyst.api.entities.action;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: AbstractInputTopiaDao.java 4972 2015-06-09 13:14:05Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/action/AbstractInputTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.utils.DaoUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.support.TopiaSqlQuery;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractInputTopiaDao extends AbstractAbstractInputTopiaDao<AbstractInput> {

    protected static final String FIND_INTERVENTION_INPUT_IDS_QUERY =
            " SELECT" +
                    "    mineralpro0_.topiaId" +
                    " FROM" +
                    "    abstractInput mineralpro0_" +
                    "    CROSS JOIN abstractAction mineralfer1_" +
                    " WHERE" +
                    "    mineralpro0_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.MineralProductInputImpl'" +
                    "    AND mineralpro0_.mineralFertilizersSpreadingAction = mineralfer1_.topiaId" +
                    "    AND mineralfer1_.%s = ?" +
                    " UNION" +
                    " SELECT" +
                    "    organicpro3_.topiaId" +
                    " FROM" +
                    "    abstractInput organicpro3_" +
                    "    CROSS JOIN abstractAction organicfer4_" +
                    " WHERE" +
                    "    organicpro3_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.OrganicProductInputImpl'" +
                    "    AND organicpro3_.organicFertilizersSpreadingAction = organicfer4_.topiaId" +
                    "    AND organicfer4_.%s = ?" +
                    " UNION" +
                    " SELECT" +
                    "    seedingpro5_.topiaId" +
                    " FROM" +
                    "    abstractInput seedingpro5_" +
                    "    CROSS JOIN abstractAction seedingact6_" +
                    " WHERE" +
                    "    seedingpro5_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.SeedingProductInputImpl'" +
                    "    AND seedingpro5_.seedingAction = seedingact6_.topiaId" +
                    "    AND seedingact6_.%s = ?" +
                    " UNION" +
                    " SELECT" +
                    "    biological7_.topiaId" +
                    " FROM" +
                    "    abstractInput biological7_" +
                    "    CROSS JOIN abstractAction biological8_" +
                    " WHERE" +
                    "    biological7_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.BiologicalProductInputImpl'" +
                    "    AND biological7_.biologicalControlAction = biological8_.topiaId" +
                    "    AND biological8_.%s = ?" +
                    " UNION" +
                    " SELECT" +
                    "    pesticidep9_.topiaId" +
                    " FROM" +
                    "    abstractInput pesticidep9_" +
                    "    CROSS JOIN abstractAction pesticides10_" +
                    " WHERE" +
                    "    pesticidep9_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.PesticideProductInputImpl'" +
                    "    AND pesticidep9_.pesticidesSpreadingAction = pesticides10_.topiaId" +
                    "    AND pesticides10_.%s = ?" +
                    " UNION" +
                    " SELECT" +
                    "    otherprodu11_.topiaId" +
                    " FROM" +
                    "    abstractInput otherprodu11_" +
                    "    CROSS JOIN abstractAction otheractio12_" +
                    " WHERE" +
                    "    otherprodu11_.topiaDiscriminator = 'fr.inra.agrosyst.api.entities.action.OtherProductInputImpl'" +
                    "    AND otheractio12_.%s = ? " +
                    "    AND (otherprodu11_.otherAction = otheractio12_.topiaId" +
                    "    OR otherprodu11_.harvestingAction = otheractio12_.topiaId" +
                    "    OR otherprodu11_.maintenancePruningVinesAction = otheractio12_.topiaId" +
                    "    OR otherprodu11_.irrigationAction = otheractio12_.topiaId" +
                    "    OR otherprodu11_.mineralFertilizersSpreadingAction = otheractio12_.topiaId" +
                    "    OR otherprodu11_.organicFertilizersSpreadingAction = otheractio12_.topiaId" +
                    "    OR otherprodu11_.pesticidesSpreadingAction = otheractio12_.topiaId" +
                    "    OR otherprodu11_.biologicalControlAction = otheractio12_.topiaId" +
                    "    OR otherprodu11_.seedingAction = otheractio12_.topiaId)";


    /**
     * Search all inputs defined on actions in given effective intervention.
     *
     * @param effectiveIntervention effective intervention
     * @return inputs used by intervention
     */
    public List<AbstractInput> findAllByEffectiveIntervention(EffectiveIntervention effectiveIntervention) {
        return findAllByIntervention(AbstractAction.PROPERTY_EFFECTIVE_INTERVENTION, effectiveIntervention);
    }

    /**
     * Search all inputs defined on actions in given practiced intervention.
     *
     * @param practicedIntervention practiced intervention
     * @return inputs used by intervention
     */
    public List<AbstractInput> findAllByPracticedIntervention(PracticedIntervention practicedIntervention) {
        List<AbstractInput> orResult = findAllByIntervention(AbstractAction.PROPERTY_PRACTICED_INTERVENTION, practicedIntervention);
        return orResult;
    }

    protected List<AbstractInput> findAllByIntervention(final String toInterventionProperty, final Object intervention) {

        final List<String> inputIds = getInterventionInputIds(toInterventionProperty, (TopiaEntity) intervention);

        List<AbstractInput> products = getInterventionInputs(inputIds);

        return products;
    }

    protected List<AbstractInput> getInterventionInputs(List<String> inputIds) {
        List<AbstractInput> products = Lists.newArrayList();
        if (!inputIds.isEmpty()) {
            Set<String> uniqueInputIds = Sets.newHashSet(inputIds);

            for (String uniqueInputId : uniqueInputIds) {
                Map<String, Object> args = DaoUtils.asArgsMap();
                StringBuilder query = new StringBuilder("FROM " + AbstractInput.class.getName() + " ai WHERE 1 = 1 ");
                query.append(DaoUtils.andAttributeEquals("ai", AbstractInput.PROPERTY_TOPIA_ID, args, uniqueInputId));
                List<AbstractInput> inputs = findAll(query.toString(), args);
                products.addAll(inputs);
            }
        }
        return products;
    }

    protected List<String> getInterventionInputIds(final String toInterventionProperty, final TopiaEntity intervention) {
        return topiaSqlSupport.findMultipleResult(new TopiaSqlQuery<String>() {
            @Override
            public PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement(String.format(FIND_INTERVENTION_INPUT_IDS_QUERY, toInterventionProperty, toInterventionProperty, toInterventionProperty, toInterventionProperty, toInterventionProperty, toInterventionProperty));
                String topiaId = intervention.getTopiaId();
                statement.setString(1, topiaId);
                statement.setString(2, topiaId);
                statement.setString(3, topiaId);
                statement.setString(4, topiaId);
                statement.setString(5, topiaId);
                statement.setString(6, topiaId);
                return statement;
            }

            @Override
            public String prepareResult(ResultSet resultSet) throws SQLException {
                String topiaid = resultSet.getString(1);
                return topiaid;
            }
        });
    }

} //AbstractInputTopiaDao
