package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: NetworkManagerTopiaDao.java 2774 2014-01-17 17:42:48Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/NetworkManagerTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Maps;

import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import fr.inra.agrosyst.api.utils.DaoUtils;

public class NetworkManagerTopiaDao extends AbstractNetworkManagerTopiaDao<NetworkManager> {

    public List<NetworkManager> getNameFilteredNetworkManager(String name) {
        String query = "FROM " + getEntityClass().getName() + " nm";
        query += " WHERE 1 = 0";
        Map<String, Object> args = Maps.newLinkedHashMap();
        if (!StringUtils.isBlank(name)){

            // Prénom
            query += DaoUtils.orAttributeLike("nm", NetworkManager.PROPERTY_AGROSYST_USER + '.' + AgrosystUser.PROPERTY_FIRST_NAME, args, name);

            // Nom
            query += DaoUtils.orAttributeLike("nm", NetworkManager.PROPERTY_AGROSYST_USER + '.' + AgrosystUser.PROPERTY_LAST_NAME, args, name);
        }
        List<NetworkManager> result = findAll(query, args);
        return result;
    }

} //NetworkManagerTopiaDao<E extends NetworkManager>
