package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectiveSeasonalCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.MeasurementSessionTopiaDao;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedZoneTopiaDao<E extends Zone> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Zone.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Zone;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            EffectiveSeasonalCropCycleTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveSeasonalCropCycle.class, EffectiveSeasonalCropCycleTopiaDao.class);
            List<EffectiveSeasonalCropCycle> list = dao
                    .forProperties(EffectiveSeasonalCropCycle.PROPERTY_ZONE, entity)
                    .findAll();
            for (EffectiveSeasonalCropCycle item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getZone())) {
                    item.setZone(null);
                }
            
            }
        }

        {
            EffectivePerennialCropCycleTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectivePerennialCropCycle.class, EffectivePerennialCropCycleTopiaDao.class);
            List<EffectivePerennialCropCycle> list = dao
                    .forProperties(EffectivePerennialCropCycle.PROPERTY_ZONE, entity)
                    .findAll();
            for (EffectivePerennialCropCycle item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getZone())) {
                    item.setZone(null);
                }
            
            }
        }

        {
            MeasurementSessionTopiaDao dao = topiaDaoSupplier
                    .getDao(MeasurementSession.class, MeasurementSessionTopiaDao.class);
            List<MeasurementSession> list = dao
                    .forProperties(MeasurementSession.PROPERTY_ZONE, entity)
                    .findAll();
            for (MeasurementSession item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getZone())) {
                    item.setZone(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM performance main, performance_zones secondary " +
                    " WHERE main.topiaId=secondary.performance " +
                    " AND secondary.zones='" + entity.getTopiaId() + "'";
            List<Performance> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.Performance.getImplementation())
                    .list();

            for (Performance item : list) {
                item.removeZones(entity);
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String code, Plot plot) {
        return forNaturalId(code, plot).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String code, Plot plot) {
        return forNaturalId(code, plot).exists();
    }

    public E createByNaturalId(String code, Plot plot) {
        return create(Zone.PROPERTY_CODE, code, Zone.PROPERTY_PLOT, plot);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String code, Plot plot) {
        return forProperties(Zone.PROPERTY_CODE, code, Zone.PROPERTY_PLOT, plot);
    }

    public E createByNotNull(String code, Plot plot) {
        return create(Zone.PROPERTY_CODE, code, Zone.PROPERTY_PLOT, plot);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAreaIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_AREA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAreaEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_AREA, v);
        return result;
    }

    @Deprecated
    public E findByArea(double v) {
        return forAreaEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByArea(double v) {
        return forAreaEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLatitudeIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_LATITUDE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLatitudeEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_LATITUDE, v);
        return result;
    }

    @Deprecated
    public E findByLatitude(Double v) {
        return forLatitudeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLatitude(Double v) {
        return forLatitudeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLongitudeIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_LONGITUDE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLongitudeEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_LONGITUDE, v);
        return result;
    }

    @Deprecated
    public E findByLongitude(Double v) {
        return forLongitudeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLongitude(Double v) {
        return forLongitudeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLineageContains(String v) {
        return forContains(Zone.PROPERTY_LINEAGE, v);
    }

    @Deprecated
    public E findContainsLineage(String v) {
        return forLineageContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsLineage(String v) {
        return forLineageContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<ZoneType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(ZoneType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(ZoneType v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(ZoneType v) {
        return forTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlotIn(Collection<Plot> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Zone.PROPERTY_PLOT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlotEquals(Plot v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Zone.PROPERTY_PLOT, v);
        return result;
    }

    @Deprecated
    public E findByPlot(Plot v) {
        return forPlotEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlot(Plot v) {
        return forPlotEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == MeasurementSession.class) {
            MeasurementSessionTopiaDao dao =
                topiaDaoSupplier.getDao(MeasurementSession.class, MeasurementSessionTopiaDao.class);
            tmp = dao.forZoneEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveSeasonalCropCycle.class) {
            EffectiveSeasonalCropCycleTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveSeasonalCropCycle.class, EffectiveSeasonalCropCycleTopiaDao.class);
            tmp = dao.forZoneEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Performance.class) {
            PerformanceTopiaDao dao =
                topiaDaoSupplier.getDao(Performance.class, PerformanceTopiaDao.class);
            tmp = dao.forZonesContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectivePerennialCropCycle.class) {
            EffectivePerennialCropCycleTopiaDao dao =
                topiaDaoSupplier.getDao(EffectivePerennialCropCycle.class, EffectivePerennialCropCycleTopiaDao.class);
            tmp = dao.forZoneEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(4);

        List<? extends TopiaEntity> list;

        list = findUsages(MeasurementSession.class, entity);
        if (!list.isEmpty()) {
            result.put(MeasurementSession.class, list);
        }

        list = findUsages(EffectiveSeasonalCropCycle.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveSeasonalCropCycle.class, list);
        }

        list = findUsages(Performance.class, entity);
        if (!list.isEmpty()) {
            result.put(Performance.class, list);
        }

        list = findUsages(EffectivePerennialCropCycle.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectivePerennialCropCycle.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedZoneTopiaDao<E extends Zone>
