package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.referential.RefStationMeteo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedWeatherStationTopiaDao<E extends WeatherStation> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) WeatherStation.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.WeatherStation;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            DomainTopiaDao dao = topiaDaoSupplier
                    .getDao(Domain.class, DomainTopiaDao.class);
            List<Domain> list = dao
                    .forProperties(Domain.PROPERTY_DEFAULT_WEATHER_STATION, entity)
                    .findAll();
            for (Domain item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDefaultWeatherStation())) {
                    item.setDefaultWeatherStation(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(RefStationMeteo refStationMeteo) {
        return create(WeatherStation.PROPERTY_REF_STATION_METEO, refStationMeteo);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(WeatherStation.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(WeatherStation.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDataIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(WeatherStation.PROPERTY_DATA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDataEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(WeatherStation.PROPERTY_DATA, v);
        return result;
    }

    @Deprecated
    public E findByData(String v) {
        return forDataEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByData(String v) {
        return forDataEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(WeatherStation.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(WeatherStation.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRefStationMeteoIn(Collection<RefStationMeteo> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(WeatherStation.PROPERTY_REF_STATION_METEO, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRefStationMeteoEquals(RefStationMeteo v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(WeatherStation.PROPERTY_REF_STATION_METEO, v);
        return result;
    }

    @Deprecated
    public E findByRefStationMeteo(RefStationMeteo v) {
        return forRefStationMeteoEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRefStationMeteo(RefStationMeteo v) {
        return forRefStationMeteoEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Domain.class) {
            DomainTopiaDao dao =
                topiaDaoSupplier.getDao(Domain.class, DomainTopiaDao.class);
            tmp = dao.forWeatherStationsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Domain.class) {
            DomainTopiaDao dao =
                topiaDaoSupplier.getDao(Domain.class, DomainTopiaDao.class);
            tmp = dao.forDefaultWeatherStationEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Domain.class, entity);
        if (!list.isEmpty()) {
            result.put(Domain.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedWeatherStationTopiaDao<E extends WeatherStation>
