package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.effective.EffectiveIntervention;
import fr.inra.agrosyst.api.entities.effective.EffectiveInterventionTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedToolsCouplingTopiaDao<E extends ToolsCoupling> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) ToolsCoupling.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.ToolsCoupling;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM effectiveIntervention main, effectiveintervention_toolcouplings secondary " +
                    " WHERE main.topiaId=secondary.effectiveIntervention " +
                    " AND secondary.toolCouplings='" + entity.getTopiaId() + "'";
            List<EffectiveIntervention> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.EffectiveIntervention.getImplementation())
                    .list();

            for (EffectiveIntervention item : list) {
                item.removeToolCouplings(entity);
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String toolsCouplingName, String code, Domain domain, RefInterventionAgrosystTravailEDI mainsActions) {
        return create(ToolsCoupling.PROPERTY_TOOLS_COUPLING_NAME, toolsCouplingName, ToolsCoupling.PROPERTY_CODE, code, ToolsCoupling.PROPERTY_DOMAIN, domain, ToolsCoupling.PROPERTY_MAINS_ACTIONS, mainsActions);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forToolsCouplingNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_TOOLS_COUPLING_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forToolsCouplingNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_TOOLS_COUPLING_NAME, v);
        return result;
    }

    @Deprecated
    public E findByToolsCouplingName(String v) {
        return forToolsCouplingNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByToolsCouplingName(String v) {
        return forToolsCouplingNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkforceIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_WORKFORCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkforceEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_WORKFORCE, v);
        return result;
    }

    @Deprecated
    public E findByWorkforce(Integer v) {
        return forWorkforceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWorkforce(Integer v) {
        return forWorkforceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_WORK_RATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_WORK_RATE, v);
        return result;
    }

    @Deprecated
    public E findByWorkRate(Double v) {
        return forWorkRateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWorkRate(Double v) {
        return forWorkRateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_TRANSIT_VOLUME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTransitVolumeEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_TRANSIT_VOLUME, v);
        return result;
    }

    @Deprecated
    public E findByTransitVolume(Double v) {
        return forTransitVolumeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTransitVolume(Double v) {
        return forTransitVolumeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forManualInterventionIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_MANUAL_INTERVENTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forManualInterventionEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_MANUAL_INTERVENTION, v);
        return result;
    }

    @Deprecated
    public E findByManualIntervention(boolean v) {
        return forManualInterventionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByManualIntervention(boolean v) {
        return forManualInterventionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTractorIn(Collection<Equipment> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_TRACTOR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTractorEquals(Equipment v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_TRACTOR, v);
        return result;
    }

    @Deprecated
    public E findByTractor(Equipment v) {
        return forTractorEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTractor(Equipment v) {
        return forTractorEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainIn(Collection<Domain> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_DOMAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainEquals(Domain v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_DOMAIN, v);
        return result;
    }

    @Deprecated
    public E findByDomain(Domain v) {
        return forDomainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDomain(Domain v) {
        return forDomainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEquipmentsContains(Equipment v) {
        return forContains(ToolsCoupling.PROPERTY_EQUIPMENTS, v);
    }

    @Deprecated
    public E findContainsEquipments(Equipment v) {
        return forEquipmentsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsEquipments(Equipment v) {
        return forEquipmentsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMainsActionsContains(RefInterventionAgrosystTravailEDI v) {
        return forContains(ToolsCoupling.PROPERTY_MAINS_ACTIONS, v);
    }

    @Deprecated
    public E findContainsMainsActions(RefInterventionAgrosystTravailEDI v) {
        return forMainsActionsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsMainsActions(RefInterventionAgrosystTravailEDI v) {
        return forMainsActionsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateUnitIn(Collection<MaterielWorkRateUnit> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(ToolsCoupling.PROPERTY_WORK_RATE_UNIT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkRateUnitEquals(MaterielWorkRateUnit v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(ToolsCoupling.PROPERTY_WORK_RATE_UNIT, v);
        return result;
    }

    @Deprecated
    public E findByWorkRateUnit(MaterielWorkRateUnit v) {
        return forWorkRateUnitEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWorkRateUnit(MaterielWorkRateUnit v) {
        return forWorkRateUnitEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == EffectiveIntervention.class) {
            EffectiveInterventionTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveIntervention.class, EffectiveInterventionTopiaDao.class);
            tmp = dao.forToolCouplingsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(EffectiveIntervention.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveIntervention.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(entity.getTractor());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedToolsCouplingTopiaDao<E extends ToolsCoupling>
