package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedPlotTopiaDao<E extends Plot> extends AbstractBasicPlotTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Plot.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Plot;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            ZoneTopiaDao dao = topiaDaoSupplier
                    .getDao(Zone.class, ZoneTopiaDao.class);
            List<Zone> list = dao
                    .forProperties(Zone.PROPERTY_PLOT, entity)
                    .findAll();
            for (Zone item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getPlot())) {
                    item.setPlot(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM performance main, performance_plots secondary " +
                    " WHERE main.topiaId=secondary.performance " +
                    " AND secondary.plots='" + entity.getTopiaId() + "'";
            List<Performance> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.Performance.getImplementation())
                    .list();

            for (Performance item : list) {
                item.removePlots(entity);
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String code, Domain domain, String name, WaterFlowDistance waterFlowDistance, MaxSlope maxSlope, BufferStrip bufferStrip) {
        return create(Plot.PROPERTY_CODE, code, Plot.PROPERTY_DOMAIN, domain, Plot.PROPERTY_NAME, name, Plot.PROPERTY_WATER_FLOW_DISTANCE, waterFlowDistance, Plot.PROPERTY_MAX_SLOPE, maxSlope, Plot.PROPERTY_BUFFER_STRIP, bufferStrip);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Plot.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Plot.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Plot.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Plot.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDeletedZonesIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Plot.PROPERTY_DELETED_ZONES, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDeletedZonesEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Plot.PROPERTY_DELETED_ZONES, v);
        return result;
    }

    @Deprecated
    public E findByDeletedZones(boolean v) {
        return forDeletedZonesEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDeletedZones(boolean v) {
        return forDeletedZonesEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLineageContains(String v) {
        return forContains(Plot.PROPERTY_LINEAGE, v);
    }

    @Deprecated
    public E findContainsLineage(String v) {
        return forLineageContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsLineage(String v) {
        return forLineageContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> foreDaplosIssuerIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Plot.PROPERTY_E_DAPLOS_ISSUER_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> foreDaplosIssuerIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Plot.PROPERTY_E_DAPLOS_ISSUER_ID, v);
        return result;
    }

    @Deprecated
    public E findByeDaplosIssuerId(String v) {
        return foreDaplosIssuerIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByeDaplosIssuerId(String v) {
        return foreDaplosIssuerIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainIn(Collection<Domain> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Plot.PROPERTY_DOMAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainEquals(Domain v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Plot.PROPERTY_DOMAIN, v);
        return result;
    }

    @Deprecated
    public E findByDomain(Domain v) {
        return forDomainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDomain(Domain v) {
        return forDomainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGrowingSystemIn(Collection<GrowingSystem> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Plot.PROPERTY_GROWING_SYSTEM, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGrowingSystemEquals(GrowingSystem v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Plot.PROPERTY_GROWING_SYSTEM, v);
        return result;
    }

    @Deprecated
    public E findByGrowingSystem(GrowingSystem v) {
        return forGrowingSystemEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGrowingSystem(GrowingSystem v) {
        return forGrowingSystemEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGroundIn(Collection<Ground> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Plot.PROPERTY_GROUND, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGroundEquals(Ground v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Plot.PROPERTY_GROUND, v);
        return result;
    }

    @Deprecated
    public E findByGround(Ground v) {
        return forGroundEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGround(Ground v) {
        return forGroundEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Zone.class) {
            ZoneTopiaDao dao =
                topiaDaoSupplier.getDao(Zone.class, ZoneTopiaDao.class);
            tmp = dao.forPlotEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Performance.class) {
            PerformanceTopiaDao dao =
                topiaDaoSupplier.getDao(Performance.class, PerformanceTopiaDao.class);
            tmp = dao.forPlotsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Zone.class, entity);
        if (!list.isEmpty()) {
            result.put(Zone.class, list);
        }

        list = findUsages(Performance.class, entity);
        if (!list.isEmpty()) {
            result.put(Performance.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedPlotTopiaDao<E extends Plot>
