package fr.inra.agrosyst.api.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedNetworkTopiaDao<E extends Network> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Network.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Network;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM growingSystem main, growingsystem_networks secondary " +
                    " WHERE main.topiaId=secondary.growingSystem " +
                    " AND secondary.networks='" + entity.getTopiaId() + "'";
            List<GrowingSystem> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.GrowingSystem.getImplementation())
                    .list();

            for (GrowingSystem item : list) {
                item.removeNetworks(entity);
            }
        }

        {
            String sql = "SELECT main.* " +
                    " FROM network main, network_parents secondary " +
                    " WHERE main.topiaId=secondary.network " +
                    " AND secondary.parents='" + entity.getTopiaId() + "'";
            List<Network> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.Network.getImplementation())
                    .list();

            for (Network item : list) {
                item.removeParents(entity);
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String name) {
        return forNaturalId(name).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String name) {
        return forNaturalId(name).exists();
    }

    public E createByNaturalId(String name) {
        return create(Network.PROPERTY_NAME, name);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String name) {
        return forProperties(Network.PROPERTY_NAME, name);
    }

    public E createByNotNull(String name, NetworkManager managers) {
        return create(Network.PROPERTY_NAME, name, Network.PROPERTY_MANAGERS, managers);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Network.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Network.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Network.PROPERTY_DESCRIPTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Network.PROPERTY_DESCRIPTION, v);
        return result;
    }

    @Deprecated
    public E findByDescription(String v) {
        return forDescriptionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDescription(String v) {
        return forDescriptionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Network.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Network.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forManagersContains(NetworkManager v) {
        return forContains(Network.PROPERTY_MANAGERS, v);
    }

    @Deprecated
    public E findContainsManagers(NetworkManager v) {
        return forManagersContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsManagers(NetworkManager v) {
        return forManagersContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParentsContains(Network v) {
        return forContains(Network.PROPERTY_PARENTS, v);
    }

    @Deprecated
    public E findContainsParents(Network v) {
        return forParentsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsParents(Network v) {
        return forParentsContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == GrowingSystem.class) {
            GrowingSystemTopiaDao dao =
                topiaDaoSupplier.getDao(GrowingSystem.class, GrowingSystemTopiaDao.class);
            tmp = dao.forNetworksContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Network.class) {
            NetworkTopiaDao dao =
                topiaDaoSupplier.getDao(Network.class, NetworkTopiaDao.class);
            tmp = dao.forParentsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(GrowingSystem.class, entity);
        if (!list.isEmpty()) {
            result.put(GrowingSystem.class, list);
        }

        list = findUsages(Network.class, entity);
        if (!list.isEmpty()) {
            result.put(Network.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getManagers() != null) {
              tmp.addAll(entity.getManagers());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedNetworkTopiaDao<E extends Network>
