package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedNetworkManagerTopiaDao<E extends NetworkManager> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) NetworkManager.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.NetworkManager;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(AgrosystUser agrosystUser) {
        return create(NetworkManager.PROPERTY_AGROSYST_USER, agrosystUser);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFromDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(NetworkManager.PROPERTY_FROM_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFromDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(NetworkManager.PROPERTY_FROM_DATE, v);
        return result;
    }

    @Deprecated
    public E findByFromDate(Date v) {
        return forFromDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFromDate(Date v) {
        return forFromDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forToDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(NetworkManager.PROPERTY_TO_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forToDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(NetworkManager.PROPERTY_TO_DATE, v);
        return result;
    }

    @Deprecated
    public E findByToDate(Date v) {
        return forToDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByToDate(Date v) {
        return forToDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(NetworkManager.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(NetworkManager.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAgrosystUserIn(Collection<AgrosystUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(NetworkManager.PROPERTY_AGROSYST_USER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAgrosystUserEquals(AgrosystUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(NetworkManager.PROPERTY_AGROSYST_USER, v);
        return result;
    }

    @Deprecated
    public E findByAgrosystUser(AgrosystUser v) {
        return forAgrosystUserEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAgrosystUser(AgrosystUser v) {
        return forAgrosystUserEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Network.class) {
            NetworkTopiaDao dao =
                topiaDaoSupplier.getDao(Network.class, NetworkTopiaDao.class);
            tmp = dao.forManagersContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Network.class, entity);
        if (!list.isEmpty()) {
            result.put(Network.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedNetworkManagerTopiaDao<E extends NetworkManager>
