package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.managementmode.CategoryStrategy;
import fr.inra.agrosyst.api.entities.managementmode.ManagementMode;
import fr.inra.agrosyst.api.entities.managementmode.ManagementModeTopiaDao;
import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceTopiaDao;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystemTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefTraitSdC;
import fr.inra.agrosyst.api.entities.referential.RefTypeAgriculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedGrowingSystemTopiaDao<E extends GrowingSystem> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) GrowingSystem.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.GrowingSystem;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PracticedSystemTopiaDao dao = topiaDaoSupplier
                    .getDao(PracticedSystem.class, PracticedSystemTopiaDao.class);
            List<PracticedSystem> list = dao
                    .forProperties(PracticedSystem.PROPERTY_GROWING_SYSTEM, entity)
                    .findAll();
            for (PracticedSystem item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGrowingSystem())) {
                    item.setGrowingSystem(null);
                }
            
            }
        }

        {
            PlotTopiaDao dao = topiaDaoSupplier
                    .getDao(Plot.class, PlotTopiaDao.class);
            List<Plot> list = dao
                    .forProperties(Plot.PROPERTY_GROWING_SYSTEM, entity)
                    .findAll();
            for (Plot item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGrowingSystem())) {
                    item.setGrowingSystem(null);
                }
            
            }
        }

        {
            ManagementModeTopiaDao dao = topiaDaoSupplier
                    .getDao(ManagementMode.class, ManagementModeTopiaDao.class);
            List<ManagementMode> list = dao
                    .forProperties(ManagementMode.PROPERTY_GROWING_SYSTEM, entity)
                    .findAll();
            for (ManagementMode item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGrowingSystem())) {
                    item.setGrowingSystem(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM performance main, growingsystems_performance secondary " +
                    " WHERE main.topiaId=secondary.performance " +
                    " AND secondary.growingSystems='" + entity.getTopiaId() + "'";
            List<Performance> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.Performance.getImplementation())
                    .list();

            for (Performance item : list) {
                item.removeGrowingSystems(entity);
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String code, GrowingPlan growingPlan) {
        return forNaturalId(code, growingPlan).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String code, GrowingPlan growingPlan) {
        return forNaturalId(code, growingPlan).exists();
    }

    public E createByNaturalId(String code, GrowingPlan growingPlan) {
        return create(GrowingSystem.PROPERTY_CODE, code, GrowingSystem.PROPERTY_GROWING_PLAN, growingPlan);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String code, GrowingPlan growingPlan) {
        return forProperties(GrowingSystem.PROPERTY_CODE, code, GrowingSystem.PROPERTY_GROWING_PLAN, growingPlan);
    }

    public E createByNotNull(String name, String code, Date updateDate, Sector sector, GrowingPlan growingPlan) {
        return create(GrowingSystem.PROPERTY_NAME, name, GrowingSystem.PROPERTY_CODE, code, GrowingSystem.PROPERTY_UPDATE_DATE, updateDate, GrowingSystem.PROPERTY_SECTOR, sector, GrowingSystem.PROPERTY_GROWING_PLAN, growingPlan);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDephyNumberIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_DEPHY_NUMBER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDephyNumberEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_DEPHY_NUMBER, v);
        return result;
    }

    @Deprecated
    public E findByDephyNumber(String v) {
        return forDephyNumberEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDephyNumber(String v) {
        return forDephyNumberEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_DESCRIPTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_DESCRIPTION, v);
        return result;
    }

    @Deprecated
    public E findByDescription(String v) {
        return forDescriptionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDescription(String v) {
        return forDescriptionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAffectedAreaRateIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_AFFECTED_AREA_RATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAffectedAreaRateEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_AFFECTED_AREA_RATE, v);
        return result;
    }

    @Deprecated
    public E findByAffectedAreaRate(Double v) {
        return forAffectedAreaRateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAffectedAreaRate(Double v) {
        return forAffectedAreaRateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAffectedWorkForceRateIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_AFFECTED_WORK_FORCE_RATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAffectedWorkForceRateEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_AFFECTED_WORK_FORCE_RATE, v);
        return result;
    }

    @Deprecated
    public E findByAffectedWorkForceRate(Integer v) {
        return forAffectedWorkForceRateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAffectedWorkForceRate(Integer v) {
        return forAffectedWorkForceRateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainsToolsUsageRateIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_DOMAINS_TOOLS_USAGE_RATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainsToolsUsageRateEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_DOMAINS_TOOLS_USAGE_RATE, v);
        return result;
    }

    @Deprecated
    public E findByDomainsToolsUsageRate(Integer v) {
        return forDomainsToolsUsageRateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDomainsToolsUsageRate(Integer v) {
        return forDomainsToolsUsageRateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStartingDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_STARTING_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStartingDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_STARTING_DATE, v);
        return result;
    }

    @Deprecated
    public E findByStartingDate(Date v) {
        return forStartingDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStartingDate(Date v) {
        return forStartingDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndingDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_ENDING_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndingDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_ENDING_DATE, v);
        return result;
    }

    @Deprecated
    public E findByEndingDate(Date v) {
        return forEndingDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEndingDate(Date v) {
        return forEndingDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndActivityCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_END_ACTIVITY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEndActivityCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_END_ACTIVITY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByEndActivityComment(String v) {
        return forEndActivityCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByEndActivityComment(String v) {
        return forEndActivityCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConductModeCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_CONDUCT_MODE_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forConductModeCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_CONDUCT_MODE_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByConductModeComment(String v) {
        return forConductModeCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByConductModeComment(String v) {
        return forConductModeCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlotOutputReasonIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_PLOT_OUTPUT_REASON, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPlotOutputReasonEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_PLOT_OUTPUT_REASON, v);
        return result;
    }

    @Deprecated
    public E findByPlotOutputReason(String v) {
        return forPlotOutputReasonEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPlotOutputReason(String v) {
        return forPlotOutputReasonEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidationDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_VALIDATION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidationDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_VALIDATION_DATE, v);
        return result;
    }

    @Deprecated
    public E findByValidationDate(Date v) {
        return forValidationDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidationDate(Date v) {
        return forValidationDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUpdateDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_UPDATE_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUpdateDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_UPDATE_DATE, v);
        return result;
    }

    @Deprecated
    public E findByUpdateDate(Date v) {
        return forUpdateDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUpdateDate(Date v) {
        return forUpdateDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCycleManagementCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_CYCLE_MANAGEMENT_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCycleManagementCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_CYCLE_MANAGEMENT_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByCycleManagementComment(String v) {
        return forCycleManagementCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCycleManagementComment(String v) {
        return forCycleManagementCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCultureManagementCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_CULTURE_MANAGEMENT_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCultureManagementCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_CULTURE_MANAGEMENT_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByCultureManagementComment(String v) {
        return forCultureManagementCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCultureManagementComment(String v) {
        return forCultureManagementCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGroundWorkCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_GROUND_WORK_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGroundWorkCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_GROUND_WORK_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByGroundWorkComment(String v) {
        return forGroundWorkCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGroundWorkComment(String v) {
        return forGroundWorkCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParcelsManagementCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_PARCELS_MANAGEMENT_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forParcelsManagementCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_PARCELS_MANAGEMENT_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByParcelsManagementComment(String v) {
        return forParcelsManagementCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByParcelsManagementComment(String v) {
        return forParcelsManagementCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNetworksContains(Network v) {
        return forContains(GrowingSystem.PROPERTY_NETWORKS, v);
    }

    @Deprecated
    public E findContainsNetworks(Network v) {
        return forNetworksContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsNetworks(Network v) {
        return forNetworksContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSectorIn(Collection<Sector> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_SECTOR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSectorEquals(Sector v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_SECTOR, v);
        return result;
    }

    @Deprecated
    public E findBySector(Sector v) {
        return forSectorEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySector(Sector v) {
        return forSectorEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGrowingPlanIn(Collection<GrowingPlan> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_GROWING_PLAN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forGrowingPlanEquals(GrowingPlan v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_GROWING_PLAN, v);
        return result;
    }

    @Deprecated
    public E findByGrowingPlan(GrowingPlan v) {
        return forGrowingPlanEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByGrowingPlan(GrowingPlan v) {
        return forGrowingPlanEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeAgricultureIn(Collection<RefTypeAgriculture> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_TYPE_AGRICULTURE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeAgricultureEquals(RefTypeAgriculture v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_TYPE_AGRICULTURE, v);
        return result;
    }

    @Deprecated
    public E findByTypeAgriculture(RefTypeAgriculture v) {
        return forTypeAgricultureEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTypeAgriculture(RefTypeAgriculture v) {
        return forTypeAgricultureEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCategoryStrategyIn(Collection<CategoryStrategy> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(GrowingSystem.PROPERTY_CATEGORY_STRATEGY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCategoryStrategyEquals(CategoryStrategy v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(GrowingSystem.PROPERTY_CATEGORY_STRATEGY, v);
        return result;
    }

    @Deprecated
    public E findByCategoryStrategy(CategoryStrategy v) {
        return forCategoryStrategyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCategoryStrategy(CategoryStrategy v) {
        return forCategoryStrategyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCharacteristicsContains(RefTraitSdC v) {
        return forContains(GrowingSystem.PROPERTY_CHARACTERISTICS, v);
    }

    @Deprecated
    public E findContainsCharacteristics(RefTraitSdC v) {
        return forCharacteristicsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsCharacteristics(RefTraitSdC v) {
        return forCharacteristicsContains(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == ManagementMode.class) {
            ManagementModeTopiaDao dao =
                topiaDaoSupplier.getDao(ManagementMode.class, ManagementModeTopiaDao.class);
            tmp = dao.forGrowingSystemEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Plot.class) {
            PlotTopiaDao dao =
                topiaDaoSupplier.getDao(Plot.class, PlotTopiaDao.class);
            tmp = dao.forGrowingSystemEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Performance.class) {
            PerformanceTopiaDao dao =
                topiaDaoSupplier.getDao(Performance.class, PerformanceTopiaDao.class);
            tmp = dao.forGrowingSystemsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == PracticedSystem.class) {
            PracticedSystemTopiaDao dao =
                topiaDaoSupplier.getDao(PracticedSystem.class, PracticedSystemTopiaDao.class);
            tmp = dao.forGrowingSystemEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(4);

        List<? extends TopiaEntity> list;

        list = findUsages(ManagementMode.class, entity);
        if (!list.isEmpty()) {
            result.put(ManagementMode.class, list);
        }

        list = findUsages(Plot.class, entity);
        if (!list.isEmpty()) {
            result.put(Plot.class, list);
        }

        list = findUsages(Performance.class, entity);
        if (!list.isEmpty()) {
            result.put(Performance.class, list);
        }

        list = findUsages(PracticedSystem.class, entity);
        if (!list.isEmpty()) {
            result.put(PracticedSystem.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedGrowingSystemTopiaDao<E extends GrowingSystem>
