package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:13 CET 2015")
public abstract class GeneratedGroundTopiaDao<E extends Ground> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Ground.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Ground;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            PlotTopiaDao dao = topiaDaoSupplier
                    .getDao(Plot.class, PlotTopiaDao.class);
            List<Plot> list = dao
                    .forProperties(Plot.PROPERTY_GROUND, entity)
                    .findAll();
            for (Plot item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getGround())) {
                    item.setGround(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(Domain domain, RefSolArvalis refSolArvalis) {
        return create(Ground.PROPERTY_DOMAIN, domain, Ground.PROPERTY_REF_SOL_ARVALIS, refSolArvalis);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Ground.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Ground.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Ground.PROPERTY_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Ground.PROPERTY_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByComment(String v) {
        return forCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByComment(String v) {
        return forCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forImportanceIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Ground.PROPERTY_IMPORTANCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forImportanceEquals(double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Ground.PROPERTY_IMPORTANCE, v);
        return result;
    }

    @Deprecated
    public E findByImportance(double v) {
        return forImportanceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByImportance(double v) {
        return forImportanceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Ground.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Ground.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainIn(Collection<Domain> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Ground.PROPERTY_DOMAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainEquals(Domain v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Ground.PROPERTY_DOMAIN, v);
        return result;
    }

    @Deprecated
    public E findByDomain(Domain v) {
        return forDomainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDomain(Domain v) {
        return forDomainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRefSolArvalisIn(Collection<RefSolArvalis> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Ground.PROPERTY_REF_SOL_ARVALIS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRefSolArvalisEquals(RefSolArvalis v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Ground.PROPERTY_REF_SOL_ARVALIS, v);
        return result;
    }

    @Deprecated
    public E findByRefSolArvalis(RefSolArvalis v) {
        return forRefSolArvalisEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRefSolArvalis(RefSolArvalis v) {
        return forRefSolArvalisEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Plot.class) {
            PlotTopiaDao dao =
                topiaDaoSupplier.getDao(Plot.class, PlotTopiaDao.class);
            tmp = dao.forGroundEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Plot.class, entity);
        if (!list.isEmpty()) {
            result.put(Plot.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedGroundTopiaDao<E extends Ground>
