package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.referential.RefMateriel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedEquipmentTopiaDao<E extends Equipment> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Equipment.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Equipment;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            ToolsCouplingTopiaDao dao = topiaDaoSupplier
                    .getDao(ToolsCoupling.class, ToolsCouplingTopiaDao.class);
            List<ToolsCoupling> list = dao
                    .forProperties(ToolsCoupling.PROPERTY_TRACTOR, entity)
                    .findAll();
            for (ToolsCoupling item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getTractor())) {
                    item.setTractor(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String name, String code, Domain domain) {
        return create(Equipment.PROPERTY_NAME, name, Equipment.PROPERTY_CODE, code, Equipment.PROPERTY_DOMAIN, domain);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Equipment.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Equipment.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Equipment.PROPERTY_DESCRIPTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Equipment.PROPERTY_DESCRIPTION, v);
        return result;
    }

    @Deprecated
    public E findByDescription(String v) {
        return forDescriptionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDescription(String v) {
        return forDescriptionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMaterielETAIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Equipment.PROPERTY_MATERIEL_ETA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMaterielETAEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Equipment.PROPERTY_MATERIEL_ETA, v);
        return result;
    }

    @Deprecated
    public E findByMaterielETA(boolean v) {
        return forMaterielETAEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMaterielETA(boolean v) {
        return forMaterielETAEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Equipment.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Equipment.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Equipment.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Equipment.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainIn(Collection<Domain> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Equipment.PROPERTY_DOMAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainEquals(Domain v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Equipment.PROPERTY_DOMAIN, v);
        return result;
    }

    @Deprecated
    public E findByDomain(Domain v) {
        return forDomainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDomain(Domain v) {
        return forDomainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRefMaterielIn(Collection<RefMateriel> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Equipment.PROPERTY_REF_MATERIEL, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forRefMaterielEquals(RefMateriel v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Equipment.PROPERTY_REF_MATERIEL, v);
        return result;
    }

    @Deprecated
    public E findByRefMateriel(RefMateriel v) {
        return forRefMaterielEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByRefMateriel(RefMateriel v) {
        return forRefMaterielEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == ToolsCoupling.class) {
            ToolsCouplingTopiaDao dao =
                topiaDaoSupplier.getDao(ToolsCoupling.class, ToolsCouplingTopiaDao.class);
            tmp = dao.forTractorEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == ToolsCoupling.class) {
            ToolsCouplingTopiaDao dao =
                topiaDaoSupplier.getDao(ToolsCoupling.class, ToolsCouplingTopiaDao.class);
            tmp = dao.forEquipmentsContains(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(ToolsCoupling.class, entity);
        if (!list.isEmpty()) {
            result.put(ToolsCoupling.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedEquipmentTopiaDao<E extends Equipment>
