package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.performance.Performance;
import fr.inra.agrosyst.api.entities.performance.PerformanceTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;
import fr.inra.agrosyst.api.entities.referential.RefLocation;
import fr.inra.agrosyst.api.entities.referential.RefOTEX;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.hibernate.Session;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;
import org.nuiton.topia.persistence.internal.support.HibernateTopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedDomainTopiaDao<E extends Domain> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Domain.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.Domain;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            GeoPointTopiaDao dao = topiaDaoSupplier
                    .getDao(GeoPoint.class, GeoPointTopiaDao.class);
            List<GeoPoint> list = dao
                    .forProperties(GeoPoint.PROPERTY_DOMAIN, entity)
                    .findAll();
            for (GeoPoint item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDomain())) {
                    item.setDomain(null);
                }
            
            }
        }

        {
            GrowingPlanTopiaDao dao = topiaDaoSupplier
                    .getDao(GrowingPlan.class, GrowingPlanTopiaDao.class);
            List<GrowingPlan> list = dao
                    .forProperties(GrowingPlan.PROPERTY_DOMAIN, entity)
                    .findAll();
            for (GrowingPlan item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDomain())) {
                    item.setDomain(null);
                }
            
            }
        }

        {
            GroundTopiaDao dao = topiaDaoSupplier
                    .getDao(Ground.class, GroundTopiaDao.class);
            List<Ground> list = dao
                    .forProperties(Ground.PROPERTY_DOMAIN, entity)
                    .findAll();
            for (Ground item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDomain())) {
                    item.setDomain(null);
                }
            
            }
        }

        {
            PlotTopiaDao dao = topiaDaoSupplier
                    .getDao(Plot.class, PlotTopiaDao.class);
            List<Plot> list = dao
                    .forProperties(Plot.PROPERTY_DOMAIN, entity)
                    .findAll();
            for (Plot item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDomain())) {
                    item.setDomain(null);
                }
            
            }
        }

        {
            CroppingPlanEntryTopiaDao dao = topiaDaoSupplier
                    .getDao(CroppingPlanEntry.class, CroppingPlanEntryTopiaDao.class);
            List<CroppingPlanEntry> list = dao
                    .forProperties(CroppingPlanEntry.PROPERTY_DOMAIN, entity)
                    .findAll();
            for (CroppingPlanEntry item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDomain())) {
                    item.setDomain(null);
                }
            
            }
        }

        {
            ToolsCouplingTopiaDao dao = topiaDaoSupplier
                    .getDao(ToolsCoupling.class, ToolsCouplingTopiaDao.class);
            List<ToolsCoupling> list = dao
                    .forProperties(ToolsCoupling.PROPERTY_DOMAIN, entity)
                    .findAll();
            for (ToolsCoupling item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDomain())) {
                    item.setDomain(null);
                }
            
            }
        }

        {
            EquipmentTopiaDao dao = topiaDaoSupplier
                    .getDao(Equipment.class, EquipmentTopiaDao.class);
            List<Equipment> list = dao
                    .forProperties(Equipment.PROPERTY_DOMAIN, entity)
                    .findAll();
            for (Equipment item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDomain())) {
                    item.setDomain(null);
                }
            
            }
        }

        {
            PriceTopiaDao dao = topiaDaoSupplier
                    .getDao(Price.class, PriceTopiaDao.class);
            List<Price> list = dao
                    .forProperties(Price.PROPERTY_DOMAIN, entity)
                    .findAll();
            for (Price item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getDomain())) {
                    item.setDomain(null);
                }
            
            }
        }

        TopiaHibernateSupport hibernateSupport = ((HibernateTopiaJpaSupport) topiaJpaSupport).getHibernateSupport();
        Session hibernateSession = hibernateSupport.getHibernateSession();

        {
            String sql = "SELECT main.* " +
                    " FROM performance main, domains_performance secondary " +
                    " WHERE main.topiaId=secondary.performance " +
                    " AND secondary.domains='" + entity.getTopiaId() + "'";
            List<Performance> list = hibernateSession
                    .createSQLQuery(sql)
                    .addEntity("main", AgrosystEntityEnum.Performance.getImplementation())
                    .list();

            for (Performance item : list) {
                item.removeDomains(entity);
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(int campaign, String code) {
        return forNaturalId(campaign, code).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(int campaign, String code) {
        return forNaturalId(campaign, code).exists();
    }

    public E createByNaturalId(int campaign, String code) {
        return create(Domain.PROPERTY_CAMPAIGN, campaign, Domain.PROPERTY_CODE, code);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(int campaign, String code) {
        return forProperties(Domain.PROPERTY_CAMPAIGN, campaign, Domain.PROPERTY_CODE, code);
    }

    public E createByNotNull(String name, String mainContact, int campaign, String code, Date updateDate, DomainType type, RefLocation location) {
        return create(Domain.PROPERTY_NAME, name, Domain.PROPERTY_MAIN_CONTACT, mainContact, Domain.PROPERTY_CAMPAIGN, campaign, Domain.PROPERTY_CODE, code, Domain.PROPERTY_UPDATE_DATE, updateDate, Domain.PROPERTY_TYPE, type, Domain.PROPERTY_LOCATION, location);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMainContactIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_MAIN_CONTACT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMainContactEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_MAIN_CONTACT, v);
        return result;
    }

    @Deprecated
    public E findByMainContact(String v) {
        return forMainContactEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMainContact(String v) {
        return forMainContactEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_DESCRIPTION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDescriptionEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_DESCRIPTION, v);
        return result;
    }

    @Deprecated
    public E findByDescription(String v) {
        return forDescriptionEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDescription(String v) {
        return forDescriptionEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCampaignIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_CAMPAIGN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCampaignEquals(int v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_CAMPAIGN, v);
        return result;
    }

    @Deprecated
    public E findByCampaign(int v) {
        return forCampaignEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCampaign(int v) {
        return forCampaignEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_ACTIVE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forActiveEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_ACTIVE, v);
        return result;
    }

    @Deprecated
    public E findByActive(boolean v) {
        return forActiveEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByActive(boolean v) {
        return forActiveEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_CROPPING_PLAN_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_CROPPING_PLAN_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanComment(String v) {
        return forCroppingPlanCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanComment(String v) {
        return forCroppingPlanCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherActivitiesCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_OTHER_ACTIVITIES_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherActivitiesCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_OTHER_ACTIVITIES_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByOtherActivitiesComment(String v) {
        return forOtherActivitiesCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtherActivitiesComment(String v) {
        return forOtherActivitiesCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStatusCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_STATUS_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forStatusCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_STATUS_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByStatusComment(String v) {
        return forStatusCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByStatusComment(String v) {
        return forStatusCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPartnersNumberIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_PARTNERS_NUMBER, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPartnersNumberEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_PARTNERS_NUMBER, v);
        return result;
    }

    @Deprecated
    public E findByPartnersNumber(Integer v) {
        return forPartnersNumberEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPartnersNumber(Integer v) {
        return forPartnersNumberEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPermanentEmployeesWorkForceIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_PERMANENT_EMPLOYEES_WORK_FORCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forPermanentEmployeesWorkForceEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_PERMANENT_EMPLOYEES_WORK_FORCE, v);
        return result;
    }

    @Deprecated
    public E findByPermanentEmployeesWorkForce(Double v) {
        return forPermanentEmployeesWorkForceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByPermanentEmployeesWorkForce(Double v) {
        return forPermanentEmployeesWorkForceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTemporaryEmployeesWorkForceIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_TEMPORARY_EMPLOYEES_WORK_FORCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTemporaryEmployeesWorkForceEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_TEMPORARY_EMPLOYEES_WORK_FORCE, v);
        return result;
    }

    @Deprecated
    public E findByTemporaryEmployeesWorkForce(Double v) {
        return forTemporaryEmployeesWorkForceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByTemporaryEmployeesWorkForce(Double v) {
        return forTemporaryEmployeesWorkForceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherWorkForceIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_OTHER_WORK_FORCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtherWorkForceEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_OTHER_WORK_FORCE, v);
        return result;
    }

    @Deprecated
    public E findByOtherWorkForce(Double v) {
        return forOtherWorkForceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtherWorkForce(Double v) {
        return forOtherWorkForceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFamilyWorkForceWageIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_FAMILY_WORK_FORCE_WAGE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forFamilyWorkForceWageEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_FAMILY_WORK_FORCE_WAGE, v);
        return result;
    }

    @Deprecated
    public E findByFamilyWorkForceWage(Integer v) {
        return forFamilyWorkForceWageEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByFamilyWorkForceWage(Integer v) {
        return forFamilyWorkForceWageEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWageCostsIn(Collection<Integer> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_WAGE_COSTS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWageCostsEquals(Integer v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_WAGE_COSTS, v);
        return result;
    }

    @Deprecated
    public E findByWageCosts(Integer v) {
        return forWageCostsEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWageCosts(Integer v) {
        return forWageCostsEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkforceCommentIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_WORKFORCE_COMMENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWorkforceCommentEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_WORKFORCE_COMMENT, v);
        return result;
    }

    @Deprecated
    public E findByWorkforceComment(String v) {
        return forWorkforceCommentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByWorkforceComment(String v) {
        return forWorkforceCommentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCropsWorkForceIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_CROPS_WORK_FORCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCropsWorkForceEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_CROPS_WORK_FORCE, v);
        return result;
    }

    @Deprecated
    public E findByCropsWorkForce(Double v) {
        return forCropsWorkForceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCropsWorkForce(Double v) {
        return forCropsWorkForceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrientationIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_ORIENTATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOrientationEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_ORIENTATION, v);
        return result;
    }

    @Deprecated
    public E findByOrientation(String v) {
        return forOrientationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOrientation(String v) {
        return forOrientationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUsedAgriculturalAreaIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_USED_AGRICULTURAL_AREA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUsedAgriculturalAreaEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_USED_AGRICULTURAL_AREA, v);
        return result;
    }

    @Deprecated
    public E findByUsedAgriculturalArea(Double v) {
        return forUsedAgriculturalAreaEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUsedAgriculturalArea(Double v) {
        return forUsedAgriculturalAreaEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMsaFeeIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_MSA_FEE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forMsaFeeEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_MSA_FEE, v);
        return result;
    }

    @Deprecated
    public E findByMsaFee(Double v) {
        return forMsaFeeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByMsaFee(Double v) {
        return forMsaFeeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAverageTenantFarmingIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_AVERAGE_TENANT_FARMING, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAverageTenantFarmingEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_AVERAGE_TENANT_FARMING, v);
        return result;
    }

    @Deprecated
    public E findByAverageTenantFarming(Double v) {
        return forAverageTenantFarmingEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAverageTenantFarming(Double v) {
        return forAverageTenantFarmingEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDecoupledAssistanceIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_DECOUPLED_ASSISTANCE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDecoupledAssistanceEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_DECOUPLED_ASSISTANCE, v);
        return result;
    }

    @Deprecated
    public E findByDecoupledAssistance(Double v) {
        return forDecoupledAssistanceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDecoupledAssistance(Double v) {
        return forDecoupledAssistanceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExperimentalAgriculturalAreaIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_EXPERIMENTAL_AGRICULTURAL_AREA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forExperimentalAgriculturalAreaEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_EXPERIMENTAL_AGRICULTURAL_AREA, v);
        return result;
    }

    @Deprecated
    public E findByExperimentalAgriculturalArea(Double v) {
        return forExperimentalAgriculturalAreaEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByExperimentalAgriculturalArea(Double v) {
        return forExperimentalAgriculturalAreaEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHomogenizationExperimentalAgriculturalAreaIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_HOMOGENIZATION_EXPERIMENTAL_AGRICULTURAL_AREA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forHomogenizationExperimentalAgriculturalAreaEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_HOMOGENIZATION_EXPERIMENTAL_AGRICULTURAL_AREA, v);
        return result;
    }

    @Deprecated
    public E findByHomogenizationExperimentalAgriculturalArea(Double v) {
        return forHomogenizationExperimentalAgriculturalAreaEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByHomogenizationExperimentalAgriculturalArea(Double v) {
        return forHomogenizationExperimentalAgriculturalAreaEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpeciesToAreaIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_SPECIES_TO_AREA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpeciesToAreaEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_SPECIES_TO_AREA, v);
        return result;
    }

    @Deprecated
    public E findBySpeciesToArea(String v) {
        return forSpeciesToAreaEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySpeciesToArea(String v) {
        return forSpeciesToAreaEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSiretIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_SIRET, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSiretEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_SIRET, v);
        return result;
    }

    @Deprecated
    public E findBySiret(String v) {
        return forSiretEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySiret(String v) {
        return forSiretEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidationDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_VALIDATION_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidationDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_VALIDATION_DATE, v);
        return result;
    }

    @Deprecated
    public E findByValidationDate(Date v) {
        return forValidationDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidationDate(Date v) {
        return forValidationDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUpdateDateIn(Collection<Date> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_UPDATE_DATE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forUpdateDateEquals(Date v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_UPDATE_DATE, v);
        return result;
    }

    @Deprecated
    public E findByUpdateDate(Date v) {
        return forUpdateDateEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByUpdateDate(Date v) {
        return forUpdateDateEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<DomainType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(DomainType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(DomainType v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(DomainType v) {
        return forTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLocationIn(Collection<RefLocation> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_LOCATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLocationEquals(RefLocation v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_LOCATION, v);
        return result;
    }

    @Deprecated
    public E findByLocation(RefLocation v) {
        return forLocationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLocation(RefLocation v) {
        return forLocationEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLegalStatusIn(Collection<RefLegalStatus> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_LEGAL_STATUS, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forLegalStatusEquals(RefLegalStatus v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_LEGAL_STATUS, v);
        return result;
    }

    @Deprecated
    public E findByLegalStatus(RefLegalStatus v) {
        return forLegalStatusEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByLegalStatus(RefLegalStatus v) {
        return forLegalStatusEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forZoningIn(Collection<Zoning> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_ZONING, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forZoningEquals(Zoning v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_ZONING, v);
        return result;
    }

    @Deprecated
    public E findByZoning(Zoning v) {
        return forZoningEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByZoning(Zoning v) {
        return forZoningEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtex18In(Collection<RefOTEX> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_OTEX18, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtex18Equals(RefOTEX v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_OTEX18, v);
        return result;
    }

    @Deprecated
    public E findByOtex18(RefOTEX v) {
        return forOtex18Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtex18(RefOTEX v) {
        return forOtex18Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtex70In(Collection<RefOTEX> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_OTEX70, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forOtex70Equals(RefOTEX v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_OTEX70, v);
        return result;
    }

    @Deprecated
    public E findByOtex70(RefOTEX v) {
        return forOtex70Equals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByOtex70(RefOTEX v) {
        return forOtex70Equals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forWeatherStationsContains(WeatherStation v) {
        return forContains(Domain.PROPERTY_WEATHER_STATIONS, v);
    }

    @Deprecated
    public E findContainsWeatherStations(WeatherStation v) {
        return forWeatherStationsContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsWeatherStations(WeatherStation v) {
        return forWeatherStationsContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDefaultWeatherStationIn(Collection<WeatherStation> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Domain.PROPERTY_DEFAULT_WEATHER_STATION, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDefaultWeatherStationEquals(WeatherStation v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Domain.PROPERTY_DEFAULT_WEATHER_STATION, v);
        return result;
    }

    @Deprecated
    public E findByDefaultWeatherStation(WeatherStation v) {
        return forDefaultWeatherStationEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDefaultWeatherStation(WeatherStation v) {
        return forDefaultWeatherStationEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == GrowingPlan.class) {
            GrowingPlanTopiaDao dao =
                topiaDaoSupplier.getDao(GrowingPlan.class, GrowingPlanTopiaDao.class);
            tmp = dao.forDomainEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Ground.class) {
            GroundTopiaDao dao =
                topiaDaoSupplier.getDao(Ground.class, GroundTopiaDao.class);
            tmp = dao.forDomainEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Equipment.class) {
            EquipmentTopiaDao dao =
                topiaDaoSupplier.getDao(Equipment.class, EquipmentTopiaDao.class);
            tmp = dao.forDomainEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == CroppingPlanEntry.class) {
            CroppingPlanEntryTopiaDao dao =
                topiaDaoSupplier.getDao(CroppingPlanEntry.class, CroppingPlanEntryTopiaDao.class);
            tmp = dao.forDomainEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Plot.class) {
            PlotTopiaDao dao =
                topiaDaoSupplier.getDao(Plot.class, PlotTopiaDao.class);
            tmp = dao.forDomainEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == GeoPoint.class) {
            GeoPointTopiaDao dao =
                topiaDaoSupplier.getDao(GeoPoint.class, GeoPointTopiaDao.class);
            tmp = dao.forDomainEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Performance.class) {
            PerformanceTopiaDao dao =
                topiaDaoSupplier.getDao(Performance.class, PerformanceTopiaDao.class);
            tmp = dao.forDomainsContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Price.class) {
            PriceTopiaDao dao =
                topiaDaoSupplier.getDao(Price.class, PriceTopiaDao.class);
            tmp = dao.forDomainEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == ToolsCoupling.class) {
            ToolsCouplingTopiaDao dao =
                topiaDaoSupplier.getDao(ToolsCoupling.class, ToolsCouplingTopiaDao.class);
            tmp = dao.forDomainEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(9);

        List<? extends TopiaEntity> list;

        list = findUsages(GrowingPlan.class, entity);
        if (!list.isEmpty()) {
            result.put(GrowingPlan.class, list);
        }

        list = findUsages(Ground.class, entity);
        if (!list.isEmpty()) {
            result.put(Ground.class, list);
        }

        list = findUsages(Equipment.class, entity);
        if (!list.isEmpty()) {
            result.put(Equipment.class, list);
        }

        list = findUsages(CroppingPlanEntry.class, entity);
        if (!list.isEmpty()) {
            result.put(CroppingPlanEntry.class, list);
        }

        list = findUsages(Plot.class, entity);
        if (!list.isEmpty()) {
            result.put(Plot.class, list);
        }

        list = findUsages(GeoPoint.class, entity);
        if (!list.isEmpty()) {
            result.put(GeoPoint.class, list);
        }

        list = findUsages(Performance.class, entity);
        if (!list.isEmpty()) {
            result.put(Performance.class, list);
        }

        list = findUsages(Price.class, entity);
        if (!list.isEmpty()) {
            result.put(Price.class, list);
        }

        list = findUsages(ToolsCoupling.class, entity);
        if (!list.isEmpty()) {
            result.put(ToolsCoupling.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getWeatherStations() != null) {
              tmp.addAll(entity.getWeatherStations());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedDomainTopiaDao<E extends Domain>
