package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpecies;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleSpeciesTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStade;
import fr.inra.agrosyst.api.entities.effective.EffectiveSpeciesStadeTopiaDao;
import fr.inra.agrosyst.api.entities.measure.Measure;
import fr.inra.agrosyst.api.entities.measure.MeasureTopiaDao;
import fr.inra.agrosyst.api.entities.measure.Observation;
import fr.inra.agrosyst.api.entities.measure.ObservationTopiaDao;
import fr.inra.agrosyst.api.entities.referential.RefEspece;
import fr.inra.agrosyst.api.entities.referential.RefVariete;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedCroppingPlanSpeciesTopiaDao<E extends CroppingPlanSpecies> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) CroppingPlanSpecies.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.CroppingPlanSpecies;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            EffectiveSpeciesStadeTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveSpeciesStade.class, EffectiveSpeciesStadeTopiaDao.class);
            List<EffectiveSpeciesStade> list = dao
                    .forProperties(EffectiveSpeciesStade.PROPERTY_CROPPING_PLAN_SPECIES, entity)
                    .findAll();
            for (EffectiveSpeciesStade item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanSpecies())) {
                    item.setCroppingPlanSpecies(null);
                }
            
            }
        }

        {
            MeasureTopiaDao dao = topiaDaoSupplier
                    .getDao(Measure.class, MeasureTopiaDao.class);
            List<Measure> list = dao
                    .forProperties(Measure.PROPERTY_CROPPING_PLAN_SPECIES, entity)
                    .findAll();
            for (Measure item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanSpecies())) {
                    item.setCroppingPlanSpecies(null);
                }
            
            }
        }

        {
            ObservationTopiaDao dao = topiaDaoSupplier
                    .getDao(Observation.class, ObservationTopiaDao.class);
            List<Observation> list = dao
                    .forProperties(Observation.PROPERTY_CROPPING_PLAN_SPECIES, entity)
                    .findAll();
            for (Observation item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanSpecies())) {
                    item.setCroppingPlanSpecies(null);
                }
            
            }
        }

        {
            EffectiveCropCycleSpeciesTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveCropCycleSpecies.class, EffectiveCropCycleSpeciesTopiaDao.class);
            List<EffectiveCropCycleSpecies> list = dao
                    .forProperties(EffectiveCropCycleSpecies.PROPERTY_CROPPING_PLAN_SPECIES, entity)
                    .findAll();
            for (EffectiveCropCycleSpecies item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanSpecies())) {
                    item.setCroppingPlanSpecies(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String code, CroppingPlanEntry croppingPlanEntry, RefEspece species) {
        return create(CroppingPlanSpecies.PROPERTY_CODE, code, CroppingPlanSpecies.PROPERTY_CROPPING_PLAN_ENTRY, croppingPlanEntry, CroppingPlanSpecies.PROPERTY_SPECIES, species);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanSpecies.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanSpecies.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanSpecies.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanSpecies.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVarietyIn(Collection<RefVariete> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanSpecies.PROPERTY_VARIETY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forVarietyEquals(RefVariete v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanSpecies.PROPERTY_VARIETY, v);
        return result;
    }

    @Deprecated
    public E findByVariety(RefVariete v) {
        return forVarietyEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByVariety(RefVariete v) {
        return forVarietyEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryIn(Collection<CroppingPlanEntry> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanSpecies.PROPERTY_CROPPING_PLAN_ENTRY, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanEntryEquals(CroppingPlanEntry v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanSpecies.PROPERTY_CROPPING_PLAN_ENTRY, v);
        return result;
    }

    @Deprecated
    public E findByCroppingPlanEntry(CroppingPlanEntry v) {
        return forCroppingPlanEntryEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCroppingPlanEntry(CroppingPlanEntry v) {
        return forCroppingPlanEntryEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpeciesIn(Collection<RefEspece> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanSpecies.PROPERTY_SPECIES, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSpeciesEquals(RefEspece v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanSpecies.PROPERTY_SPECIES, v);
        return result;
    }

    @Deprecated
    public E findBySpecies(RefEspece v) {
        return forSpeciesEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySpecies(RefEspece v) {
        return forSpeciesEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == CroppingPlanEntry.class) {
            CroppingPlanEntryTopiaDao dao =
                topiaDaoSupplier.getDao(CroppingPlanEntry.class, CroppingPlanEntryTopiaDao.class);
            tmp = dao.forCroppingPlanSpeciesContains(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveCropCycleSpecies.class) {
            EffectiveCropCycleSpeciesTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveCropCycleSpecies.class, EffectiveCropCycleSpeciesTopiaDao.class);
            tmp = dao.forCroppingPlanSpeciesEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Measure.class) {
            MeasureTopiaDao dao =
                topiaDaoSupplier.getDao(Measure.class, MeasureTopiaDao.class);
            tmp = dao.forCroppingPlanSpeciesEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveSpeciesStade.class) {
            EffectiveSpeciesStadeTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveSpeciesStade.class, EffectiveSpeciesStadeTopiaDao.class);
            tmp = dao.forCroppingPlanSpeciesEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Observation.class) {
            ObservationTopiaDao dao =
                topiaDaoSupplier.getDao(Observation.class, ObservationTopiaDao.class);
            tmp = dao.forCroppingPlanSpeciesEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(5);

        List<? extends TopiaEntity> list;

        list = findUsages(CroppingPlanEntry.class, entity);
        if (!list.isEmpty()) {
            result.put(CroppingPlanEntry.class, list);
        }

        list = findUsages(EffectiveCropCycleSpecies.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveCropCycleSpecies.class, list);
        }

        list = findUsages(Measure.class, entity);
        if (!list.isEmpty()) {
            result.put(Measure.class, list);
        }

        list = findUsages(EffectiveSpeciesStade.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveSpeciesStade.class, list);
        }

        list = findUsages(Observation.class, entity);
        if (!list.isEmpty()) {
            result.put(Observation.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedCroppingPlanSpeciesTopiaDao<E extends CroppingPlanSpecies>
