package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnectionTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNodeTopiaDao;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycleTopiaDao;
import fr.inra.agrosyst.api.entities.managementmode.Strategy;
import fr.inra.agrosyst.api.entities.managementmode.StrategyTopiaDao;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.measure.MeasurementSessionTopiaDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryWithUniqueResultStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedCroppingPlanEntryTopiaDao<E extends CroppingPlanEntry> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) CroppingPlanEntry.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.CroppingPlanEntry;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            CroppingPlanSpeciesTopiaDao dao = topiaDaoSupplier
                    .getDao(CroppingPlanSpecies.class, CroppingPlanSpeciesTopiaDao.class);
            List<CroppingPlanSpecies> list = dao
                    .forProperties(CroppingPlanSpecies.PROPERTY_CROPPING_PLAN_ENTRY, entity)
                    .findAll();
            for (CroppingPlanSpecies item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanEntry())) {
                    item.setCroppingPlanEntry(null);
                }
            
            }
        }

        {
            StrategyTopiaDao dao = topiaDaoSupplier
                    .getDao(Strategy.class, StrategyTopiaDao.class);
            List<Strategy> list = dao
                    .forProperties(Strategy.PROPERTY_CROPPING_PLAN_ENTRY, entity)
                    .findAll();
            for (Strategy item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanEntry())) {
                    item.setCroppingPlanEntry(null);
                }
            
            }
        }

        {
            EffectivePerennialCropCycleTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectivePerennialCropCycle.class, EffectivePerennialCropCycleTopiaDao.class);
            List<EffectivePerennialCropCycle> list = dao
                    .forProperties(EffectivePerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY, entity)
                    .findAll();
            for (EffectivePerennialCropCycle item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanEntry())) {
                    item.setCroppingPlanEntry(null);
                }
            
            }
        }

        {
            MeasurementSessionTopiaDao dao = topiaDaoSupplier
                    .getDao(MeasurementSession.class, MeasurementSessionTopiaDao.class);
            List<MeasurementSession> list = dao
                    .forProperties(MeasurementSession.PROPERTY_CROPPING_PLAN_ENTRY, entity)
                    .findAll();
            for (MeasurementSession item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanEntry())) {
                    item.setCroppingPlanEntry(null);
                }
            
            }
        }

        {
            EffectiveCropCycleNodeTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveCropCycleNode.class, EffectiveCropCycleNodeTopiaDao.class);
            List<EffectiveCropCycleNode> list = dao
                    .forProperties(EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY, entity)
                    .findAll();
            for (EffectiveCropCycleNode item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getCroppingPlanEntry())) {
                    item.setCroppingPlanEntry(null);
                }
            
            }
        }

        {
            EffectiveCropCycleConnectionTopiaDao dao = topiaDaoSupplier
                    .getDao(EffectiveCropCycleConnection.class, EffectiveCropCycleConnectionTopiaDao.class);
            List<EffectiveCropCycleConnection> list = dao
                    .forProperties(EffectiveCropCycleConnection.PROPERTY_INTERMEDIATE_CROPPING_PLAN_ENTRY, entity)
                    .findAll();
            for (EffectiveCropCycleConnection item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getIntermediateCroppingPlanEntry())) {
                    item.setIntermediateCroppingPlanEntry(null);
                }
            
            }
        }

        super.delete(entity);
    }

    @Deprecated
    public E findByNaturalId(String code, Domain domain) {
        return forNaturalId(code, domain).findUnique();
    }

    @Deprecated
    public boolean existByNaturalId(String code, Domain domain) {
        return forNaturalId(code, domain).exists();
    }

    public E createByNaturalId(String code, Domain domain) {
        return create(CroppingPlanEntry.PROPERTY_CODE, code, CroppingPlanEntry.PROPERTY_DOMAIN, domain);
    }

    public TopiaQueryBuilderRunQueryWithUniqueResultStep<E> forNaturalId(String code, Domain domain) {
        return forProperties(CroppingPlanEntry.PROPERTY_CODE, code, CroppingPlanEntry.PROPERTY_DOMAIN, domain);
    }

    public E createByNotNull(String name, String code, Domain domain, CroppingEntryType type) {
        return create(CroppingPlanEntry.PROPERTY_NAME, name, CroppingPlanEntry.PROPERTY_CODE, code, CroppingPlanEntry.PROPERTY_DOMAIN, domain, CroppingPlanEntry.PROPERTY_TYPE, type);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanEntry.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanEntry.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSellingPriceIn(Collection<Double> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanEntry.PROPERTY_SELLING_PRICE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSellingPriceEquals(Double v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanEntry.PROPERTY_SELLING_PRICE, v);
        return result;
    }

    @Deprecated
    public E findBySellingPrice(Double v) {
        return forSellingPriceEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySellingPrice(Double v) {
        return forSellingPriceEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanEntry.PROPERTY_CODE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCodeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanEntry.PROPERTY_CODE, v);
        return result;
    }

    @Deprecated
    public E findByCode(String v) {
        return forCodeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByCode(String v) {
        return forCodeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedIn(Collection<Boolean> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanEntry.PROPERTY_VALIDATED, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forValidatedEquals(boolean v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanEntry.PROPERTY_VALIDATED, v);
        return result;
    }

    @Deprecated
    public E findByValidated(boolean v) {
        return forValidatedEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByValidated(boolean v) {
        return forValidatedEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainIn(Collection<Domain> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanEntry.PROPERTY_DOMAIN, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forDomainEquals(Domain v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanEntry.PROPERTY_DOMAIN, v);
        return result;
    }

    @Deprecated
    public E findByDomain(Domain v) {
        return forDomainEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByDomain(Domain v) {
        return forDomainEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forCroppingPlanSpeciesContains(CroppingPlanSpecies v) {
        return forContains(CroppingPlanEntry.PROPERTY_CROPPING_PLAN_SPECIES, v);
    }

    @Deprecated
    public E findContainsCroppingPlanSpecies(CroppingPlanSpecies v) {
        return forCroppingPlanSpeciesContains(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllContainsCroppingPlanSpecies(CroppingPlanSpecies v) {
        return forCroppingPlanSpeciesContains(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeIn(Collection<CroppingEntryType> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(CroppingPlanEntry.PROPERTY_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTypeEquals(CroppingEntryType v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(CroppingPlanEntry.PROPERTY_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByType(CroppingEntryType v) {
        return forTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByType(CroppingEntryType v) {
        return forTypeEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == MeasurementSession.class) {
            MeasurementSessionTopiaDao dao =
                topiaDaoSupplier.getDao(MeasurementSession.class, MeasurementSessionTopiaDao.class);
            tmp = dao.forCroppingPlanEntryEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == Strategy.class) {
            StrategyTopiaDao dao =
                topiaDaoSupplier.getDao(Strategy.class, StrategyTopiaDao.class);
            tmp = dao.forCroppingPlanEntryEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveCropCycleNode.class) {
            EffectiveCropCycleNodeTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveCropCycleNode.class, EffectiveCropCycleNodeTopiaDao.class);
            tmp = dao.forCroppingPlanEntryEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == CroppingPlanSpecies.class) {
            CroppingPlanSpeciesTopiaDao dao =
                topiaDaoSupplier.getDao(CroppingPlanSpecies.class, CroppingPlanSpeciesTopiaDao.class);
            tmp = dao.forCroppingPlanEntryEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectiveCropCycleConnection.class) {
            EffectiveCropCycleConnectionTopiaDao dao =
                topiaDaoSupplier.getDao(EffectiveCropCycleConnection.class, EffectiveCropCycleConnectionTopiaDao.class);
            tmp = dao.forIntermediateCroppingPlanEntryEquals(entity).findAll();
            result.addAll(tmp);
        }

        if (type == EffectivePerennialCropCycle.class) {
            EffectivePerennialCropCycleTopiaDao dao =
                topiaDaoSupplier.getDao(EffectivePerennialCropCycle.class, EffectivePerennialCropCycleTopiaDao.class);
            tmp = dao.forCroppingPlanEntryEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(6);

        List<? extends TopiaEntity> list;

        list = findUsages(MeasurementSession.class, entity);
        if (!list.isEmpty()) {
            result.put(MeasurementSession.class, list);
        }

        list = findUsages(Strategy.class, entity);
        if (!list.isEmpty()) {
            result.put(Strategy.class, list);
        }

        list = findUsages(EffectiveCropCycleNode.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveCropCycleNode.class, list);
        }

        list = findUsages(CroppingPlanSpecies.class, entity);
        if (!list.isEmpty()) {
            result.put(CroppingPlanSpecies.class, list);
        }

        list = findUsages(EffectiveCropCycleConnection.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectiveCropCycleConnection.class, list);
        }

        list = findUsages(EffectivePerennialCropCycle.class, entity);
        if (!list.isEmpty()) {
            result.put(EffectivePerennialCropCycle.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (entity.getCroppingPlanSpecies() != null) {
              tmp.addAll(entity.getCroppingPlanSpecies());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedCroppingPlanEntryTopiaDao<E extends CroppingPlanEntry>
