package fr.inra.agrosyst.api.entities;

import fr.inra.agrosyst.api.entities.security.AgrosystUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedAttachmentMetadataTopiaDao<E extends AttachmentMetadata> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) AttachmentMetadata.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.AttachmentMetadata;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            AttachmentContentTopiaDao dao = topiaDaoSupplier
                    .getDao(AttachmentContent.class, AttachmentContentTopiaDao.class);
            List<AttachmentContent> list = dao
                    .forProperties(AttachmentContent.PROPERTY_ATTACHMENT_METADATA, entity)
                    .findAll();
            for (AttachmentContent item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getAttachmentMetadata())) {
                    item.setAttachmentMetadata(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public E createByNotNull(String name, long size, String objectReferenceId, AgrosystUser author) {
        return create(AttachmentMetadata.PROPERTY_NAME, name, AttachmentMetadata.PROPERTY_SIZE, size, AttachmentMetadata.PROPERTY_OBJECT_REFERENCE_ID, objectReferenceId, AttachmentMetadata.PROPERTY_AUTHOR, author);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentMetadata.PROPERTY_NAME, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentMetadata.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContentTypeIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentMetadata.PROPERTY_CONTENT_TYPE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContentTypeEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentMetadata.PROPERTY_CONTENT_TYPE, v);
        return result;
    }

    @Deprecated
    public E findByContentType(String v) {
        return forContentTypeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByContentType(String v) {
        return forContentTypeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSizeIn(Collection<Long> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentMetadata.PROPERTY_SIZE, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forSizeEquals(long v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentMetadata.PROPERTY_SIZE, v);
        return result;
    }

    @Deprecated
    public E findBySize(long v) {
        return forSizeEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllBySize(long v) {
        return forSizeEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forObjectReferenceIdIn(Collection<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentMetadata.PROPERTY_OBJECT_REFERENCE_ID, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forObjectReferenceIdEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentMetadata.PROPERTY_OBJECT_REFERENCE_ID, v);
        return result;
    }

    @Deprecated
    public E findByObjectReferenceId(String v) {
        return forObjectReferenceIdEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByObjectReferenceId(String v) {
        return forObjectReferenceIdEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAuthorIn(Collection<AgrosystUser> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentMetadata.PROPERTY_AUTHOR, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAuthorEquals(AgrosystUser v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentMetadata.PROPERTY_AUTHOR, v);
        return result;
    }

    @Deprecated
    public E findByAuthor(AgrosystUser v) {
        return forAuthorEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAuthor(AgrosystUser v) {
        return forAuthorEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == AttachmentContent.class) {
            AttachmentContentTopiaDao dao =
                topiaDaoSupplier.getDao(AttachmentContent.class, AttachmentContentTopiaDao.class);
            tmp = dao.forAttachmentMetadataEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(AttachmentContent.class, entity);
        if (!list.isEmpty()) {
            result.put(AttachmentContent.class, list);
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAttachmentMetadataTopiaDao<E extends AttachmentMetadata>
