package fr.inra.agrosyst.api.entities;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Thu Dec 17 16:21:12 CET 2015")
public abstract class GeneratedAttachmentContentTopiaDao<E extends AttachmentContent> extends AbstractAgrosystTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) AttachmentContent.class;
    }

    @Override
    public AgrosystEntityEnum getTopiaEntityEnum() {
        return AgrosystEntityEnum.AttachmentContent;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        super.delete(entity);
    }

    public E createByNotNull(Blob content, AttachmentMetadata attachmentMetadata) {
        return create(AttachmentContent.PROPERTY_CONTENT, content, AttachmentContent.PROPERTY_ATTACHMENT_METADATA, attachmentMetadata);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContentIn(Collection<Blob> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentContent.PROPERTY_CONTENT, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContentEquals(Blob v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentContent.PROPERTY_CONTENT, v);
        return result;
    }

    @Deprecated
    public E findByContent(Blob v) {
        return forContentEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByContent(Blob v) {
        return forContentEquals(v).findAll();
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAttachmentMetadataIn(Collection<AttachmentMetadata> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(AttachmentContent.PROPERTY_ATTACHMENT_METADATA, (Collection) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAttachmentMetadataEquals(AttachmentMetadata v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(AttachmentContent.PROPERTY_ATTACHMENT_METADATA, v);
        return result;
    }

    @Deprecated
    public E findByAttachmentMetadata(AttachmentMetadata v) {
        return forAttachmentMetadataEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByAttachmentMetadata(AttachmentMetadata v) {
        return forAttachmentMetadataEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        return new LinkedList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

    @Override
    public List<TopiaEntity> getAggregate(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            result.add(e);
            TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
            result.addAll(dao.getAggregate(e));
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite(E entity) throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity e : tmp) {
            if (e != null) {
                result.add(e);
                TopiaDao<TopiaEntity> dao = (TopiaDao<TopiaEntity>) topiaDaoSupplier.getDao(e.getClass());
                result.addAll(dao.getComposite(e));
            }
        }
        return result;
    }

} //GeneratedAttachmentContentTopiaDao<E extends AttachmentContent>
