package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: EquipmentTopiaDao.java 2776 2014-01-18 20:56:29Z athimel $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/EquipmentTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.util.List;
import java.util.Map;

import org.nuiton.topia.persistence.TopiaException;

import fr.inra.agrosyst.api.utils.DaoUtils;

/**
 * Custom method on domain materiel DAO.
 *
 * @author Eric Chatellier
 */
public class EquipmentTopiaDao extends AbstractEquipmentTopiaDao<Equipment> {

    public List<Equipment> findAllByDomainOrdered(Domain domain) throws TopiaException {
        String query = "FROM " + getEntityClass().getName() + " e " +
                " WHERE e." + Equipment.PROPERTY_DOMAIN + " = :domain" +
                " ORDER BY e." + Equipment.PROPERTY_NAME;

        Map<String, Object> args = DaoUtils.asArgsMap("domain", domain);
        List<Equipment> result = findAll(query, args);
        return result;
    }

} //DomainMaterielDAOImpl<E extends DomainMateriel>
