package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: CroppingPlanEntryTopiaDao.java 4972 2015-06-09 13:14:05Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/CroppingPlanEntryTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleConnection;
import fr.inra.agrosyst.api.entities.effective.EffectiveCropCycleNode;
import fr.inra.agrosyst.api.entities.effective.EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.entities.managementmode.Strategy;
import fr.inra.agrosyst.api.entities.measure.MeasurementSession;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedPerennialCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.utils.DaoUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class CroppingPlanEntryTopiaDao extends AbstractCroppingPlanEntryTopiaDao<CroppingPlanEntry> {

    protected static final String EFFECTIVE_CROPPING_PLAN_ENTRY_ID = EffectivePerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY + "." + CroppingPlanEntry.PROPERTY_TOPIA_ID;
    protected static final String PRACTICED_NODE_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS = PracticedCropCycleNode.PROPERTY_PRACTICED_SEASONAL_CROP_CYCLE + "." + PracticedSeasonalCropCycle.PROPERTY_PRACTICED_SYSTEM + "." + PracticedSystem.PROPERTY_CAMPAIGNS;
    protected static final String PRACTICED_CONNECTION_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS = PracticedCropCycleConnection.PROPERTY_SOURCE + "." + PRACTICED_NODE_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS;
    protected static final String PRACTICED_CONNECTION_TARGET_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS = PracticedCropCycleConnection.PROPERTY_TARGET + "." + PRACTICED_NODE_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS;
    protected static final String EFFECTIVE_CONNECTION_SOURCE_CROPPING_PLAN_ENTRY_ID = EffectiveCropCycleConnection.PROPERTY_SOURCE + "." + EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY + "." + CroppingPlanEntry.PROPERTY_TOPIA_ID;
    protected static final String EFFECTIVE_CONNECTION_TARGET_CROPPING_PLAN_ENTRY_ID = EffectiveCropCycleConnection.PROPERTY_TARGET + "." + EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY + "." + CroppingPlanEntry.PROPERTY_TOPIA_ID;
    protected static final String CROPPING_PLAN_ENTRY_DOMAIN_CAMPAIGN = CroppingPlanEntry.PROPERTY_DOMAIN + "." + Domain.PROPERTY_CAMPAIGN;

    private static final Log log = LogFactory.getLog(CroppingPlanEntryTopiaDao.class);

    public List<CroppingPlanEntry> findEntriesFromCode(String croppingPlanEntryCode, Set<Integer> campaigns) {

        String query = "FROM " + getEntityClass().getName() + " e ";
        Map<String, Object> args = Maps.newLinkedHashMap();

        // code
        query += " WHERE e." + CroppingPlanEntry.PROPERTY_CODE + " = :code";
        args.put("code", croppingPlanEntryCode);

        // campaigns
        query += DaoUtils.andAttributeIn("e", CROPPING_PLAN_ENTRY_DOMAIN_CAMPAIGN, args, campaigns);

        List<CroppingPlanEntry> entries = findAll(query + " ORDER BY e." + CROPPING_PLAN_ENTRY_DOMAIN_CAMPAIGN + " DESC", args);

        return entries;

    }

    protected Map<String, Long> queryBody(Iterable<String> croppingPlanIds, String campaign, String subQuery) {

        Map<String, Long> result = Maps.newHashMap();

        Map<String, Object> args = Maps.newLinkedHashMap();
        Set<String> cpeIds = Sets.newHashSet(croppingPlanIds);

        if (campaign != null) {
            args.put("campaign" , campaign);
        }

        String query = " SELECT cpe." + CroppingPlanEntry.PROPERTY_TOPIA_ID + ", ";

        query += "(" + subQuery + ")";

        query +=" FROM " + CroppingPlanEntry.class.getName() + " cpe WHERE 1 = 1 " ;
        query += DaoUtils.andAttributeIn("cpe", CroppingPlanEntry.PROPERTY_TOPIA_ID, args, cpeIds);

        List<Object[]> cpes = findAll(query, args);
        for (Object[] cpeTuple : cpes) {
            String cpeId = (String) cpeTuple[0];
            Long count = (Long)cpeTuple[1];
            result.put(cpeId, count);
        }

        return result;
    }

    public Map<String, Long> getCPEUsedForStrategies(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + Strategy.class.getName() + " s " +
        "       WHERE s." + Strategy.PROPERTY_CROPPING_PLAN_ENTRY + "." + CroppingPlanEntry.PROPERTY_TOPIA_ID + " = cpe." + CroppingPlanEntry.PROPERTY_TOPIA_ID;
        Map<String, Long> result = queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForMesurementSessions(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM "+ MeasurementSession.class.getName() + " ms " +
        "        WHERE ms." + MeasurementSession.PROPERTY_CROPPING_PLAN_ENTRY + "." + CroppingPlanEntry.PROPERTY_TOPIA_ID + " = cpe." + CroppingPlanEntry.PROPERTY_TOPIA_ID;
        Map<String, Long> result = queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForEffectiveCropCycleNode(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + EffectiveCropCycleNode.class.getName() + " eccn " +
        "        WHERE eccn." + EffectiveCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY + "." + CroppingPlanEntry.PROPERTY_TOPIA_ID + " = cpe." + CroppingPlanEntry.PROPERTY_TOPIA_ID;
        Map<String, Long> result = queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForEffectiveCropCycleConnections(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + EffectiveCropCycleConnection.class.getName() + " eccc " +
        "        WHERE eccc." + EffectiveCropCycleConnection.PROPERTY_INTERMEDIATE_CROPPING_PLAN_ENTRY + "." + CroppingPlanEntry.PROPERTY_TOPIA_ID + " = cpe." + CroppingPlanEntry.PROPERTY_TOPIA_ID +
        "        OR eccc." + EFFECTIVE_CONNECTION_SOURCE_CROPPING_PLAN_ENTRY_ID + " = cpe." + CroppingPlanEntry.PROPERTY_TOPIA_ID +
        "        OR eccc." + EFFECTIVE_CONNECTION_TARGET_CROPPING_PLAN_ENTRY_ID + " = cpe." + CroppingPlanEntry.PROPERTY_TOPIA_ID;
        Map<String, Long> result = queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForPracticedCropCycleConnections(Iterable<String> cpeIds, String campaign) {
        String query = "SELECT COUNT(*) FROM " + PracticedCropCycleConnection.class.getName() + " pccc " +
        "        WHERE pccc." + PracticedCropCycleConnection.PROPERTY_INTERMEDIATE_CROPPING_PLAN_ENTRY_CODE + " = cpe." + CroppingPlanEntry.PROPERTY_CODE +
        "        AND (" +
                "        (pccc." + PRACTICED_CONNECTION_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS + " LIKE :campaign" +
                "     ) " +
        "             OR " +
        "                (pccc." + PRACTICED_CONNECTION_TARGET_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS + " LIKE :campaign) " +
                "     ) ";
        Map<String, Long> result = queryBody(cpeIds, campaign, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForPracticedCropCycleNodes(Iterable<String> cpeIds, String campaign) {
        String query = "SELECT COUNT(*) FROM " + PracticedCropCycleNode.class.getName() + " pccn " +
        "        WHERE pccn." + PRACTICED_NODE_SOURCE_SEASONAL_CYCLE_PRACTICED_SYSTEM_CAMPAIGNS + " LIKE :campaign " +
        "        AND pccn." + PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE + " = cpe." + CroppingPlanEntry.PROPERTY_CODE;
        Map<String, Long> result = queryBody(cpeIds, campaign, query);
        return result;
    }

    public Map<String, Long> getCPEUsedForEffectivePerenialCropCycles(Iterable<String> cpeIds) {
        String query = "SELECT COUNT(*) FROM " + EffectivePerennialCropCycle.class.getName() + " epcc " +
        "        WHERE epcc."+ EFFECTIVE_CROPPING_PLAN_ENTRY_ID + " = cpe." + CroppingPlanEntry.PROPERTY_TOPIA_ID;
        Map<String, Long> result = queryBody(cpeIds, null, query);
        return result;
    }

    public Map<String, Long> getCPEUsedPracticedPerenialCropCycles(Iterable<String> cpeIds, String campaign) {
        String query = "SELECT COUNT(*) FROM " + PracticedPerennialCropCycle.class.getName() + " ppcc " +
        "        WHERE ppcc." + PracticedPerennialCropCycle.PROPERTY_CROPPING_PLAN_ENTRY_CODE + " = cpe." + CroppingPlanEntry.PROPERTY_CODE +
        "        AND ppcc." + PracticedPerennialCropCycle.PROPERTY_PRACTICED_SYSTEM + "." + PracticedSystem.PROPERTY_CAMPAIGNS + " LIKE :campaign ";
        Map<String, Long> result = queryBody(cpeIds, campaign, query);
        return result;
    }
}
