package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: AgrosystTopiaApplicationContext.java 4361 2014-09-26 15:06:29Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/AgrosystTopiaApplicationContext.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import java.io.File;
import java.util.Properties;

import fr.inra.agrosyst.services.AgrosystServiceConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;

/**
 * Agrosyst application context.
 * 
 * @author Eric Chatellier
 */
public class AgrosystTopiaApplicationContext extends AbstractAgrosystTopiaApplicationContext {

    private static final Log log = LogFactory.getLog(AgrosystTopiaApplicationContext.class);

    protected AgrosystServiceConfig config;

    public AgrosystTopiaApplicationContext(AgrosystServiceConfig config, Properties topiaProperties) {
        super(topiaProperties);
        this.config = config;
    }

    /**
     * Init application.
     * 
     * <ul>
     * <li>Creation application schema</li>
     * <li>Update log4j configuration</li>
     * </ul>
     */
    public void applicationInit() {
        
        // replace application logging to custom file
        String logFileLocation = config.getLogFileLocation();
        if (StringUtils.isNotBlank(logFileLocation)) {

            File log4jConfigurationFile = new File(logFileLocation);
            String log4jConfigurationFileAbsolutePath = log4jConfigurationFile.getAbsolutePath();

            if (log4jConfigurationFile.exists()) {

                if (log.isInfoEnabled()) {
                    log.info("will use logging configuration " + log4jConfigurationFileAbsolutePath);
                }

                // reset logger configuration
                LogManager.resetConfiguration();

                // use generate log config file
                PropertyConfigurator.configure(log4jConfigurationFileAbsolutePath);

            } else {
                if (log.isWarnEnabled()) {
                    log.warn("there is no file " + log4jConfigurationFileAbsolutePath + ". Default logging configuration will be used.");
                }
            }
        }
    }

    public void setConfig(AgrosystServiceConfig config) {
        this.config = config;
    }

    public AgrosystServiceConfig getConfig() {
        return config;
    }

} //AgrosystTopiaApplicationContext
