package fr.inra.agrosyst.api.entities;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: AbstractAgrosystTopiaDao.java 4653 2014-12-15 14:00:17Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.3/agrosyst-services/src/main/java/fr/inra/agrosyst/api/entities/AbstractAgrosystTopiaDao.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Supplier;
import fr.inra.agrosyst.services.common.CacheAware;
import fr.inra.agrosyst.services.common.CacheService;
import fr.inra.agrosyst.services.common.ProjectionHelper;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;

import java.util.HashMap;

public abstract class AbstractAgrosystTopiaDao<E extends TopiaEntity> extends AbstractTopiaDao<E> implements CacheAware {

    private ProjectionHelper projectionHelper;
    protected Supplier<CacheService> cacheServiceSupplier;

    public Iterable<String> findPropertyDistinctValues(String property) {
        String query = "SELECT DISTINCT " + property + " " + newFromClause() + " ORDER BY " + property;
        Iterable<String> result = findAllLazy(query, new HashMap<String, Object>());
        return result;
    }

    public ProjectionHelper getProjectionHelper() {
        if (projectionHelper == null) {
            AgrosystTopiaDaoSupplier supplier = (AgrosystTopiaDaoSupplier) topiaDaoSupplier;
            projectionHelper = new ProjectionHelper(supplier, topiaJpaSupport, getCacheService());
        }
        return projectionHelper;
    }

    public CacheService getCacheService() {
        return cacheServiceSupplier.get();
    }

    @Override
    public void setCacheServiceSupplier(Supplier<CacheService> cacheServiceSupplier) {
        this.cacheServiceSupplier = cacheServiceSupplier;
    }
}
