---
-- %%Ignore-License
---

DROP INDEX IF EXISTS action_to_effective_intervention_idx;
DROP INDEX IF EXISTS action_to_practiced_intervention_idx;

DROP INDEX IF EXISTS input_to_mineral_product_input_idx;
DROP INDEX IF EXISTS input_to_organic_product_input_idx;
DROP INDEX IF EXISTS input_to_seeding_product_input_idx;
DROP INDEX IF EXISTS input_to_biological_product_input_idx;
DROP INDEX IF EXISTS input_to_pesticides_spreading_action_idx;
DROP INDEX IF EXISTS input_to_irrigation_action_idx;
DROP INDEX IF EXISTS input_to_maintenance_pruning_vine_action_idx;
DROP INDEX IF EXISTS input_to_harvesting_action_idx;
DROP INDEX IF EXISTS input_to_other_action_idx;

ALTER TABLE abstractinput ADD COLUMN harvestingaction character varying(255);
ALTER TABLE abstractinput ADD COLUMN irrigationaction character varying(255);
ALTER TABLE abstractinput ADD COLUMN maintenancePruningVinesAction character varying(255);

CREATE INDEX action_to_practiced_intervention_idx ON abstractaction (practicedintervention NULLS LAST, topiadiscriminator);
CREATE INDEX action_to_effective_intervention_idx ON abstractaction (effectiveintervention NULLS LAST, topiadiscriminator);

CREATE INDEX input_to_biological_product_input_idx ON abstractinput (biologicalcontrolaction NULLS LAST, topiadiscriminator);
CREATE INDEX input_to_harvesting_action_idx ON abstractinput (harvestingAction NULLS LAST, topiadiscriminator);
CREATE INDEX input_to_irrigation_action_idx ON abstractinput (irrigationAction NULLS LAST, topiadiscriminator);
CREATE INDEX input_to_maintenance_pruning_vine_action_idx ON abstractinput (maintenancePruningVinesAction NULLS LAST, topiadiscriminator);
CREATE INDEX input_to_mineral_product_input_idx ON abstractinput (mineralfertilizersspreadingaction NULLS LAST, topiadiscriminator);
CREATE INDEX input_to_organic_product_input_idx ON abstractinput (organicfertilizersspreadingaction NULLS LAST, topiadiscriminator);
CREATE INDEX input_to_other_action_idx ON abstractinput (otherAction NULLS LAST, topiadiscriminator);
CREATE INDEX input_to_pesticides_spreading_action_idx ON abstractinput (pesticidesspreadingaction NULLS LAST, topiadiscriminator);
CREATE INDEX input_to_seeding_product_input_idx ON abstractinput (seedingaction NULLS LAST, topiadiscriminator);
