---
-- %%Ignore-License
---

-- add column solOccupationPercent to PracticedPerennialCropCycle.
ALTER TABLE practicedperennialcropcycle ADD COLUMN "soloccupationpercent" double precision;
-- par défaut la valeur est 100
UPDATE practicedperennialcropcycle SET soloccupationpercent = 100;

-- si sur un system pratiqué il existe plusieurs practicedperennialcropcycle alors la valeur du soloccupationpercent est divisé par le nombre de cycle pour atteindre au total 100
CREATE TABLE concernedps (psid varchar(255));
INSERT INTO concernedps (psid)
      SELECT DISTINCT ppccs.ps FROM
        (SELECT nbppcc.practicedsystem as ps, nbppcc.numb as nb FROM (
          SELECT pcc.practicedsystem, count(pcc.practicedsystem) as numb
          FROM practicedcropcycle pcc, practicedperennialcropcycle ppcc
          WHERE pcc.topiaid = ppcc.topiaid GROUP by pcc.practicedsystem) as nbppcc
        WHERE nbppcc.numb > 1) AS ppccs, practicedcropcycle pcc, practicedperennialcropcycle ppcc
      WHERE ppccs.ps = pcc.practicedsystem AND pcc.topiaid = ppcc.topiaid ORDER by ppccs.ps;

CREATE TABLE concernedppccs (ppccid varchar(255), psid varchar(255));

INSERT INTO concernedppccs (ppccid, psid )
      SELECT ppcc.topiaid, ppccs.ps FROM
        (SELECT nbppcc.practicedsystem as ps, nbppcc.numb as nb FROM (
          SELECT pcc.practicedsystem, count(pcc.practicedsystem) as numb
          FROM practicedcropcycle pcc, practicedperennialcropcycle ppcc
          WHERE pcc.topiaid = ppcc.topiaid GROUP by pcc.practicedsystem) as nbppcc
        WHERE nbppcc.numb > 1) AS ppccs, practicedcropcycle pcc, practicedperennialcropcycle ppcc
      WHERE ppccs.ps = pcc.practicedsystem AND pcc.topiaid = ppcc.topiaid ORDER by ppccs.ps;


CREATE OR REPLACE FUNCTION getconcernedps() RETURNS SETOF concernedps AS
$BODY$
DECLARE
    nbelements integer;
    soloccupationpercentvalue practicedperennialcropcycle.soloccupationpercent%TYPE;
    ppcctopiaid practicedperennialcropcycle.topiaid%TYPE;
    r concernedps%rowtype;
    rppcc concernedppccs%rowtype;
    i integer;
BEGIN
  SELECT count(*) into nbelements FROM concernedps;
  --for i in 1..nbelements LOOP
  --SELECT * FROM concernedps;
  --END LOOP;

  FOR r IN SELECT * FROM concernedps
    LOOP
      SELECT count(*) into nbelements  FROM concernedppccs cppccs WHERE cppccs.psid = r.psid;
      SELECT 1 into i;

      FOR rppcc IN SELECT cppccs.ppccid FROM concernedppccs cppccs WHERE cppccs.psid = r.psid

        LOOP
          if nbelements = 1 THEN
            soloccupationpercentvalue := 100;
          ELSif nbelements > i then
            soloccupationpercentvalue := 100/nbelements;
            SELECT i+1 into i;
          ELSE
            soloccupationpercentvalue := (100 - (soloccupationpercentvalue * nbelements)) + soloccupationpercentvalue;
          END IF;

          raise log  'soloccupationpercentvalue is %', soloccupationpercentvalue;
          --return next rppcc;
          UPDATE practicedperennialcropcycle SET soloccupationpercent = soloccupationpercentvalue WHERE topiaid = rppcc.ppccid;
        END loop;

      RETURN NEXT r; -- return current row of SELECT
    END LOOP;
    RETURN;
END
$BODY$
LANGUAGE 'plpgsql' ;

SELECT psid FROM getconcernedps();

DROP FUNCTION getconcernedps();
DROP TABLE concernedppccs;
DROP TABLE concernedps;