/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.caliper.feed.event.CaliperFeedReaderEvent;
import fr.ifremer.tutti.caliper.feed.event.CaliperFeedReaderListener;
import fr.ifremer.tutti.caliper.feed.record.CaliperFeedReaderMeasureRecord;
import fr.ifremer.tutti.ichtyometer.feed.event.IchtyometerFeedReaderEvent;
import fr.ifremer.tutti.ichtyometer.feed.event.IchtyometerFeedReaderListener;
import fr.ifremer.tutti.ichtyometer.feed.record.IchtyometerFeedReaderMeasureRecord;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.Rtp;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Sexs;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCache;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCaches;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.cruise.CruiseCache;
import fr.ifremer.tutti.service.cruise.CruiseCacheLoader;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.EditSpeciesBatchPanelUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.AverageWeightsHistogramHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequenciesHistogramHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SamplingNotificationZoneHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions.ApplySpeciesFrequencyRafaleAction;
import fr.ifremer.tutti.ui.swing.util.SoundEngine;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnRowModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnUIHandler;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import fr.ifremer.tutti.ui.swing.util.table.CaracteristicColumnIdentifier;
import fr.ifremer.tutti.util.Units;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.ApplicationUIAction;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SpeciesFrequencyUIHandler
extends AbstractTuttiTableUIHandler<SpeciesFrequencyRowModel, SpeciesFrequencyUIModel, SpeciesFrequencyUI>
implements CaracteristicMapColumnUIHandler {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIHandler.class);
    public static final String OBS_TABLE_CARD = "obsTableCard";
    public static final String EDIT_CARACTERISTICS_CARD = "editCaracteristicsCard";
    private SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyEditor;
    private TaxonCache taxonCache;
    private Map<String, Caracteristic> lengthStepCaracteristics;
    protected WeightUnit weightUnit;
    protected final IchtyometerFeedReaderListener ichtyometerFeedReaderListener = new IchtyometerFeedReaderListener(){

        public void recordRead(IchtyometerFeedReaderEvent event) {
            IchtyometerFeedReaderMeasureRecord record = event.getRecord();
            SwingUtilities.invokeLater(() -> {
                if (!((SpeciesFrequencyUIModel)((Object)((Object)SpeciesFrequencyUIHandler.this.getModel()))).isSimpleCountingMode()) {
                    SpeciesFrequencyUIHandler.this.consumeIchtyometerFeedRecord(record);
                }
            });
        }
    };
    protected final CaliperFeedReaderListener caliperFeedReaderListener = new CaliperFeedReaderListener(){

        public void recordRead(CaliperFeedReaderEvent event) {
            CaliperFeedReaderMeasureRecord record = event.getRecord();
            SwingUtilities.invokeLater(() -> {
                if (!((SpeciesFrequencyUIModel)((Object)((Object)SpeciesFrequencyUIHandler.this.getModel()))).isSimpleCountingMode()) {
                    SpeciesFrequencyUIHandler.this.consumeCaliperFeedRecord(record);
                }
            });
        }
    };
    protected final PropertyChangeListener listenIchtyomerIsConnected = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean connected = (Boolean)evt.getNewValue();
            if (connected && SpeciesFrequencyUIHandler.this.frequencyEditor != null) {
                SpeciesFrequencyUIHandler.this.listenItchtyometer();
            }
            SwingUtilities.invokeLater(SpeciesFrequencyUIHandler.this::updateLogVisibility);
        }
    };
    protected final PropertyChangeListener listenCaliperIsConnected = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean connected = (Boolean)evt.getNewValue();
            if (connected && SpeciesFrequencyUIHandler.this.frequencyEditor != null) {
                SpeciesFrequencyUIHandler.this.listenCaliper();
            }
            SwingUtilities.invokeLater(SpeciesFrequencyUIHandler.this::updateLogVisibility);
        }
    };
    protected ApplySpeciesFrequencyRafaleAction applySpeciesFrequencyRafaleAction;
    protected SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport;
    protected IndividualObservationBatchTableHandler individualObservationBatchTableHandler;
    protected AverageWeightsHistogramHandler averageWeightsHistogramHandler;
    protected FrequenciesHistogramHandler frequenciesHistogramHandler;
    protected SamplingNotificationZoneHandler samplingNotificationZoneHandler;
    protected Decorator<Caracteristic> caracteristicDecorator;
    protected Decorator<Caracteristic> caracteristicTipDecorator;
    protected Decorator<CaracteristicQualitativeValue> caracteristicQualitativeDecorator;
    protected SoundEngine soundEngine;
    protected PropertyChangeListener listenFishingOperationReloadInDataContext = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            TuttiDataContext source = (TuttiDataContext)event.getSource();
            FishingOperation fishingOperation = source.getFishingOperation();
            if (log.isInfoEnabled()) {
                log.info((Object)("Reloading fishing operation in model: " + fishingOperation));
            }
            ((SpeciesFrequencyUIModel)((Object)SpeciesFrequencyUIHandler.this.getModel())).setFishingOperation(fishingOperation);
        }
    };

    public SpeciesFrequencyUIHandler() {
        super("lengthStep", "number", "weight");
    }

    public SpeciesFrequencyTableModel getTableModel() {
        return (SpeciesFrequencyTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesFrequencyUI)this.ui).getTable();
    }

    @Override
    public boolean isRowValid(SpeciesFrequencyRowModel row) {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        return model.isRowValid(row);
    }

    @Override
    public CaracteristicMapEditorUI getCaracteristicMapEditor() {
        return ((SpeciesFrequencyUI)this.ui).getObsCaracteristicCaracteristicMapEditor();
    }

    @Override
    public void showCaracteristicMapEditor(CaracteristicMapColumnRowModel editRow) {
        IndividualObservationBatchRowModel row = (IndividualObservationBatchRowModel)editRow;
        WeightUnit individualObservationWeightUnit = this.getConfig().getIndividualObservationWeightUnit();
        String title = String.format("<html><body style='color:black;'><strong>%s - %s %s - %s %s</strong> - %s</body></html>", row.getRankOrder(), row.getSize(), ((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStepCaracteristicUnit(), individualObservationWeightUnit.renderWeight(row.getWeight()), individualObservationWeightUnit.getShortLabel(), I18n.t((String)"tutti.editIndividualObservationBatch.table.header.otherCaracteristics", (Object[])new Object[0]));
        ((SpeciesFrequencyUI)this.ui).getObsCaracteristicMapEditorReminderLabel().setTitle(title);
        ((SpeciesFrequencyUI)this.ui).getObsPanelLayout().setSelected(EDIT_CARACTERISTICS_CARD);
    }

    @Override
    public void hideCaracteristicMapEditor() {
        ((SpeciesFrequencyUI)this.ui).getObsPanelLayout().setSelected(OBS_TABLE_CARD);
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesFrequencyRowModel> rows) {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        model.reloadRows();
        this.getTableModel().setRows(rows);
        SpeciesFrequencyLogsTableModel logsTableModel = (SpeciesFrequencyLogsTableModel)((Object)((SpeciesFrequencyUI)this.ui).getLogsTable().getModel());
        logsTableModel.setRows(new ArrayList());
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setModify(false);
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesFrequencyRowModel> rowMonitor, SpeciesFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        ((SpeciesFrequencyUI)this.ui).getValidator().doValidate();
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return ((SpeciesFrequencyUI)this.ui).getValidator();
    }

    public void beforeInit(SpeciesFrequencyUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.speciesOrBenthosBatchUISupport = ui.getContextValue(SpeciesOrBenthosBatchUISupport.class, ui.getSpeciesOrBenthosContext());
        this.weightUnit = this.speciesOrBenthosBatchUISupport.getWeightUnit();
        this.caracteristicDecorator = this.getDecorator(Caracteristic.class, "parameterOnlyWithUnit");
        this.caracteristicTipDecorator = this.getDecorator(Caracteristic.class, "withUnit");
        this.caracteristicQualitativeDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        this.soundEngine = this.getContext().getSoundEngine();
        Caracteristic sexCaracteristic = this.getPersistenceService().getSexCaracteristic();
        TuttiDataContext dataContext = this.getDataContext();
        SampleCategoryModel sampleCategoryModel = dataContext.getSampleCategoryModel();
        ArrayList<Caracteristic> protocolIndividualObservationCaracteristics = new ArrayList<Caracteristic>(dataContext.getDefaultIndividualObservationCaracteristics());
        Optional optionalCruiseCache = dataContext.getOptionalCruiseCache();
        if (!optionalCruiseCache.isPresent()) {
            TuttiUIContext uiContext = this.getContext();
            ProgressionModel progressionModel = new ProgressionModel();
            progressionModel.setTotal(1);
            CruiseCacheLoader cruiseCacheLoader = uiContext.createCruiseCacheLoader(progressionModel);
            dataContext.loadCruiseCache(cruiseCacheLoader);
            optionalCruiseCache = dataContext.getOptionalCruiseCache();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cruise cache" + optionalCruiseCache.get()));
            }
        }
        TuttiProtocol protocol = dataContext.isProtocolFilled() ? dataContext.getProtocol() : null;
        SpeciesFrequencyUIModel model = new SpeciesFrequencyUIModel(this.speciesOrBenthosBatchUISupport, this.getConfig().getIndividualObservationWeightUnit(), sampleCategoryModel, sexCaracteristic, protocolIndividualObservationCaracteristics, (CruiseCache)optionalCruiseCache.get(), dataContext.getCruiseId(), protocol);
        ((SpeciesFrequencyUI)this.ui).setContextValue(model);
        this.getContext().addPropertyChangeListener("ichtyometerConnected", this.listenIchtyomerIsConnected);
        this.getContext().addPropertyChangeListener("caliperConnected", this.listenCaliperIsConnected);
        this.getDataContext().addPropertyChangeListener("fishingOperationId", this.listenFishingOperationReloadInDataContext);
    }

    public void afterInit(SpeciesFrequencyUI ui) {
        ((SpeciesFrequencyUI)this.getUI()).getSearchSpeciesInPrevCatchesButton().setAccelerator(KeyStroke.getKeyStroke(80, 2));
        ((SpeciesFrequencyUI)this.getUI()).getSearchSpeciesInNextCatchesButton().setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.applySpeciesFrequencyRafaleAction = new ApplySpeciesFrequencyRafaleAction(ui);
        this.initUI(ui);
        ArrayList lengthStepCaracteristics = new ArrayList(this.getDataContext().getLengthStepCaracteristics());
        this.lengthStepCaracteristics = TuttiEntities.splitById(lengthStepCaracteristics);
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        this.taxonCache = "SPECIES".equals(ui.getSpeciesOrBenthosContext()) ? TaxonCaches.createSpeciesCacheWithoutVernacularCode((TuttiPersistence)this.getPersistenceService(), (TuttiProtocol)this.getDataContext().getProtocol()) : TaxonCaches.createBenthosCacheWithoutVernacularCode((TuttiPersistence)this.getPersistenceService(), (TuttiProtocol)this.getDataContext().getProtocol());
        Caracteristic modelCaracteristic = model.getLengthStepCaracteristic();
        this.initBeanFilterableComboBox(((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox(), lengthStepCaracteristics, modelCaracteristic);
        model.setStep(modelCaracteristic);
        model.setMinStep(null);
        model.setMaxStep(null);
        ui.getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getRafaleStepField().getModel().getNumberValue();
                    SpeciesFrequencyUIHandler.this.applySpeciesFrequencyRafaleAction.applyRafaleStep(step, false);
                    JTextField field = (JTextField)e.getSource();
                    field.selectAll();
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", evt -> {
            Caracteristic newValue = (Caracteristic)evt.getNewValue();
            model.setStep(newValue);
            if (CollectionUtils.isNotEmpty(((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).getRows())) {
                for (SpeciesFrequencyRowModel rowModel : ((SpeciesFrequencyUIModel)((Object)((Object)this.getModel()))).getRows()) {
                    rowModel.setLengthStepCaracteristic(newValue);
                    this.recomputeRowValidState(rowModel);
                }
            }
            if (!model.isInitBatchEdition()) {
                ((SpeciesFrequencyUI)this.ui).getValidator().doValidate();
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristicUnit", evt -> {
            String unit = (String)evt.getNewValue();
            if (unit == null) {
                unit = I18n.t((String)"tutti.editSpeciesFrequencies.unkownStepUnit", (Object[])new Object[0]);
            }
            ((SpeciesFrequencyUI)this.getUI()).getMinStepLabel().setText(Units.getLabelWithUnit((String)I18n.t((String)"tutti.editSpeciesFrequencies.field.minStep", (Object[])new Object[0]), (String)unit));
            ((SpeciesFrequencyUI)this.getUI()).getMinStepLabel().setToolTipText(Units.getLabelWithUnit((String)I18n.t((String)"tutti.editSpeciesFrequencies.field.minStep.tip", (Object[])new Object[0]), (String)unit));
            ((SpeciesFrequencyUI)this.getUI()).getMaxStepLabel().setText(Units.getLabelWithUnit((String)I18n.t((String)"tutti.editSpeciesFrequencies.field.maxStep", (Object[])new Object[0]), (String)unit));
            ((SpeciesFrequencyUI)this.getUI()).getMaxStepLabel().setToolTipText(Units.getLabelWithUnit((String)I18n.t((String)"tutti.editSpeciesFrequencies.field.maxStep.tip", (Object[])new Object[0]), (String)unit));
            ((SpeciesFrequencyUI)this.getUI()).getRafaleStepLabel().setText(Units.getLabelWithUnit((String)I18n.t((String)"tutti.editSpeciesFrequencies.field.rafaleStep", (Object[])new Object[0]), (String)unit));
            ((SpeciesFrequencyUI)this.getUI()).getRafaleStepLabel().setToolTipText(Units.getLabelWithUnit((String)I18n.t((String)"tutti.editSpeciesFrequencies.field.rafaleStep.tip", (Object[])new Object[0]), (String)unit));
            TableColumnExt column = (TableColumnExt)((SpeciesFrequencyUI)this.getUI()).getTable().getColumn(SpeciesFrequencyTableModel.LENGTH_STEP);
            String lengthStepLabelWithUnit = Units.getLabelWithUnit((String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (String)unit);
            column.setHeaderValue((Object)lengthStepLabelWithUnit);
            column.setToolTipText(lengthStepLabelWithUnit);
            column = (TableColumnExt)((SpeciesFrequencyUI)this.getUI()).getObsTable().getColumn(IndividualObservationBatchTableModel.SIZE);
            column.setHeaderValue((Object)Units.getLabelWithUnit((String)I18n.t((String)"tutti.editIndividualObservationBatch.table.header.size", (Object[])new Object[0]), (String)unit));
            column.setToolTipText(Units.getLabelWithUnit((String)I18n.t((String)"tutti.editIndividualObservationBatch.table.header.size", (Object[])new Object[0]), (String)unit));
        });
        model.addPropertyChangeListener("frequenciesConfigurationMode", evt -> {
            FrequencyConfigurationMode newValue = (FrequencyConfigurationMode)((Object)((Object)evt.getNewValue()));
            SwingUtilities.invokeLater(() -> {
                JComponent componentToFocus = this.getComponentToFocus(newValue);
                if (componentToFocus != null) {
                    componentToFocus.grabFocus();
                }
                this.updateLogVisibility();
            });
        });
        model.addVetoableChangeListener("copyRtpWeights", evt -> {
            long rowsWithUserData;
            boolean newCopyRtpWeights = (Boolean)evt.getNewValue();
            if (newCopyRtpWeights && (rowsWithUserData = model.getRows().stream().filter(SpeciesFrequencyRowModel::withWeight).count()) > 0L) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyRtpWeights.confirm.message", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyRtpWeights.confirm.help", (Object[])new Object[0]));
                int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyRtpWeights.confirm.title", (Object[])new Object[0]), 2, 3);
                if (i == 2) {
                    throw new PropertyVetoException("The user does not want to erase his data.", evt);
                }
            }
        });
        model.addPropertyChangeListener("copyRtpWeights", evt -> {
            SpeciesFrequencyUIModel source = (SpeciesFrequencyUIModel)((Object)((Object)evt.getSource()));
            source.getRows().forEach(source::computeRowWeightWithRtp);
            source.reloadRows();
            source.getFrequencyTableModel().fireTableDataChanged();
        });
        model.getIndividualObservationModel().addPropertyChangeListener("rowsInError", evt -> {
            IndividualObservationBatchUIModel source = (IndividualObservationBatchUIModel)((Object)((Object)evt.getSource()));
            if (source.getRows() != null) {
                boolean nonEmptyRow = source.isNonEmptyRowInError();
                model.setNonEmptyIndividualObservationRowsInError(nonEmptyRow);
            }
        });
        ui.getSimpleCountingWeightField().setNumberPattern(this.weightUnit.getNumberEditorPattern());
        this.initDataTable();
        this.initLogTable();
        this.individualObservationBatchTableHandler = new IndividualObservationBatchTableHandler(ui);
        this.averageWeightsHistogramHandler = new AverageWeightsHistogramHandler(ui);
        this.frequenciesHistogramHandler = new FrequenciesHistogramHandler(ui);
        this.samplingNotificationZoneHandler = new SamplingNotificationZoneHandler(ui, model.getIndividualObservationModel().getSamplingNotificationZoneModel(), model.getIndividualObservationUICache());
        this.listenValidatorValid((SimpleBeanValidator)ui.getValidator(), model);
        Color bgSaveBt = ui.getSaveAndStayButton().getBackground();
        boolean opacity = ui.getSaveAndStayButton().isOpaque();
        model.addPropertyChangeListener("modify", evt -> {
            if (Boolean.FALSE.equals(evt.getNewValue())) {
                ui.getSaveAndStayButton().setOpaque(opacity);
                ui.getSaveAndStayButton().setBackground(bgSaveBt);
            } else {
                ui.getSaveAndStayButton().setOpaque(true);
                ui.getSaveAndStayButton().setBackground(Color.RED);
            }
        });
    }

    protected JComponent getComponentToFocus() {
        FrequencyConfigurationMode configurationMode = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getConfigurationMode();
        Object componentToFocus = this.getComponentToFocus(configurationMode);
        if (componentToFocus == null) {
            componentToFocus = ((SpeciesFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox();
        }
        return componentToFocus;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.getDataContext().removePropertyChangeListener("fishingOperationId", this.listenFishingOperationReloadInDataContext);
        TuttiUIContext context = this.getContext();
        context.removePropertyChangeListener("ichtyometerConnected", this.listenIchtyomerIsConnected);
        context.removePropertyChangeListener("caliperConnected", this.listenCaliperIsConnected);
        if (context.isIchtyometerConnected()) {
            context.getIchtyometerReader().removeFeedModeReaderListener(this.ichtyometerFeedReaderListener);
        }
        if (context.isCaliperConnected()) {
            context.getCaliperReader().removeFeedModeReaderListener(this.caliperFeedReaderListener);
        }
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        IOUtils.closeQuietly((Closeable)this.individualObservationBatchTableHandler);
        IOUtils.closeQuietly((Closeable)this.averageWeightsHistogramHandler);
        IOUtils.closeQuietly((Closeable)this.frequenciesHistogramHandler);
        IOUtils.closeQuietly((Closeable)this.samplingNotificationZoneHandler);
        this.frequencyEditor = null;
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean(null);
        this.clearValidators();
        model.setValid(false);
        model.setSimpleCount(null);
        model.setModify(false);
        EditSpeciesBatchPanelUI parent = (EditSpeciesBatchPanelUI)this.getParentContainer(EditSpeciesBatchPanelUI.class);
        parent.switchToEditBatch();
    }

    public void editBatch(SpeciesFrequencyCellComponent.FrequencyCellEditor editor, String title) {
        SpeciesBatchRowModel speciesBatch = editor.getEditRow();
        Objects.requireNonNull(speciesBatch, "Impossible d'\u00e9diter un lot non renseign\u00e9");
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        Objects.requireNonNull(title, "title can't be null here ?!");
        model.getAverageWeightsHistogramModel().setTitle(title);
        model.getFrequenciesHistogramModel().setTitle(title);
        this.frequencyEditor = editor;
        model.setNextEditableRowIndex(this.frequencyEditor.getNextEditableRowIndex());
        List<SpeciesFrequencyRowModel> frequency = speciesBatch.getFrequency();
        List<IndividualObservationBatchRowModel> individualObservations = speciesBatch.getIndividualObservation();
        model.setBatch(speciesBatch);
        model.setFishingOperation(this.getDataContext().getFishingOperation());
        model.setMinStep(null);
        model.setMaxStep(null);
        model.setRtp(null);
        model.setCopyRtpWeights(false);
        SpeciesProtocol speciesProtocol = this.getDataContext().isProtocolFilled() ? this.speciesOrBenthosBatchUISupport.getSpeciesProtocol(speciesBatch.getSpecies()) : null;
        Rtp rtp = null;
        if (speciesProtocol != null) {
            Caracteristic sexCaracteristic = model.getIndividualObservationModel().getSexCaracteristic();
            CaracteristicQualitativeValue sampleCategoryValue = (CaracteristicQualitativeValue)speciesBatch.getSampleCategoryValue(sexCaracteristic.getIdAsInt());
            rtp = sampleCategoryValue != null ? (Sexs.isMale((CaracteristicQualitativeValue)sampleCategoryValue) ? speciesProtocol.getRtpMale() : (Sexs.isFemale((CaracteristicQualitativeValue)sampleCategoryValue) ? speciesProtocol.getRtpFemale() : speciesProtocol.getRtpUndefined())) : speciesProtocol.getRtpUndefined();
        }
        model.setRtp(rtp);
        this.individualObservationBatchTableHandler.initMaturityCaracteristic(speciesProtocol);
        this.individualObservationBatchTableHandler.initDefaultCaracteristics(speciesBatch);
        model.getIndividualObservationUICache().initFishingOperation(model.getFishingOperation());
        this.loadFrequenciesAndObservations(frequency, individualObservations, false);
        this.samplingNotificationZoneHandler.editBatch(speciesBatch);
        if (this.getContext().isIchtyometerConnected()) {
            this.listenItchtyometer();
        }
        if (this.getContext().isCaliperConnected()) {
            this.listenCaliper();
        }
        model.setModify(false);
    }

    public boolean leaveIfConfirmed() {
        boolean result;
        boolean bl = result = !((SpeciesFrequencyUIModel)((Object)this.getModel())).isModify() || this.askCancelEditBeforeLeaving();
        if (result) {
            ApplicationUIAction action = (ApplicationUIAction)((SpeciesFrequencyUI)this.getUI()).getCancelButton().getAction();
            this.getContext().getActionEngine().runInternalAction(action.getLogicAction());
        } else if (log.isInfoEnabled()) {
            log.info((Object)"Use cancel change on tab, stay on frequencies screen.");
        }
        return result;
    }

    public boolean askCancelEditBeforeLeaving() {
        String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.askToCancelEditFrequencies.message", (Object[])new Object[0]), I18n.t((String)"tutti.askToCancelEditFrequencies.help", (Object[])new Object[0]));
        int saveResponse = JOptionPane.showOptionDialog(this.getTopestUI(), htmlMessage, I18n.t((String)"tutti.askToCancelEditFrequencies.title", (Object[])new Object[0]), 2, 3, null, new String[]{I18n.t((String)"tutti.option.continue", (Object[])new Object[0]), I18n.t((String)"tutti.option.cancel", (Object[])new Object[0])}, I18n.t((String)"tutti.option.cancel", (Object[])new Object[0]));
        return saveResponse == 0;
    }

    public void setCopyIndividualObservationMode(CopyIndividualObservationMode newCopyMode) {
        long rowsWithUserData;
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        if (model.isInitBatchEdition()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Skip ask user to confirm copyIndividualObservationMode changed from " + model.getCopyIndividualObservationMode() + " to " + newCopyMode));
            }
            return;
        }
        if (!model.isCopyIndividualObservationAll() && (rowsWithUserData = model.isCopyIndividualObservationSize() ? model.getRows().stream().filter(SpeciesFrequencyRowModel::withWeight).count() : model.getRows().stream().filter(row -> row.withLengthStep() || row.withNumber() || row.withWeight()).count()) > 0L) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyMode.confirm.message", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyMode.confirm.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(((SpeciesFrequencyUI)this.ui).getHandler().getTopestUI(), htmlMessage, I18n.t((String)"tutti.editSpeciesFrequencies.changeCopyMode.confirm.title", (Object[])new Object[0]), 2, 3);
            if (i == 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User cancel modification...");
                }
                switch (model.getCopyIndividualObservationMode()) {
                    case ALL: {
                        ((SpeciesFrequencyUI)this.ui).getCopyAllButton().setSelected(true);
                        break;
                    }
                    case NOTHING: {
                        ((SpeciesFrequencyUI)this.ui).getCopyNothingButton().setSelected(true);
                        break;
                    }
                    case SIZE: {
                        ((SpeciesFrequencyUI)this.ui).getCopySizesButton().setSelected(true);
                    }
                }
                return;
            }
        }
        model.setCopyIndividualObservationMode(newCopyMode);
    }

    protected void initDataTable() {
        final JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.LENGTH_STEP, "\\d{0,6}(\\.\\d{0,1})?", (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.NUMBER, "\\d{0,6}", (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.WEIGHT, this.weightUnit, (JTable)table);
        final Color computedDataColor = this.getConfig().getColorComputedWeights();
        TableCellRenderer renderer = new TableCellRenderer(){
            TableCellRenderer delegate;
            {
                this.delegate = SpeciesFrequencyUIHandler.this.newWeightCellRenderer(table.getDefaultRenderer(Number.class), SpeciesFrequencyUIHandler.this.weightUnit);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result = this.delegate.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
                if (result instanceof JLabel) {
                    JLabel jLabel = (JLabel)result;
                    jLabel.setForeground(computedDataColor);
                    jLabel.setFont(jLabel.getFont().deriveFont(2));
                }
                return result;
            }
        };
        this.addColumnToModel((TableColumnModel)columnModel, null, renderer, SpeciesFrequencyTableModel.RTP_COMPUTED_WEIGHT, this.weightUnit);
        SpeciesFrequencyTableModel tableModel = new SpeciesFrequencyTableModel(this.weightUnit, this.getConfig().getIndividualObservationWeightUnit(), (TableColumnModelExt)columnModel, (SpeciesFrequencyUIModel)((Object)this.getModel()));
        ((SpeciesFrequencyUIModel)((Object)this.getModel())).setFrequencyTableModel(tableModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        HighlightPredicate.NotHighlightPredicate notSelectedPredicate = new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED);
        HighlightPredicate weightTooDifferentFromRtpPredicate = (renderer, adapter) -> {
            boolean result = false;
            if (table.getModel() instanceof SpeciesFrequencyTableModel) {
                SpeciesFrequencyTableModel tableModel = (SpeciesFrequencyTableModel)((Object)((Object)table.getModel()));
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                SpeciesFrequencyRowModel row = (SpeciesFrequencyRowModel)((Object)tableModel.getEntry(modelRow));
                Float rate = this.getConfig().getDifferenceRateBetweenWeightAndRtpWeight();
                result = row.withWeight() && row.withRtpComputedWeight() && Math.abs(row.getWeight().floatValue() - row.getRtpComputedWeight().floatValue()) >= row.getWeight().floatValue() * rate.floatValue() / 100.0f;
            }
            return result;
        };
        Highlighter weightTooDifferentFromRtpHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{notSelectedPredicate, weightTooDifferentFromRtpPredicate}), (Color)this.getConfig().getColorWarningRow());
        table.addHighlighter(weightTooDifferentFromRtpHighlighter);
        Highlighter weightTooDifferentFromRtpSelectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.IS_SELECTED, weightTooDifferentFromRtpPredicate}), (Color)this.getConfig().getColorWarningRow().darker());
        table.addHighlighter(weightTooDifferentFromRtpSelectedHighlighter);
    }

    protected void initLogTable() {
        JXTable logTable = ((SpeciesFrequencyUI)this.ui).getLogsTable();
        DefaultTableColumnModelExt logColumnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)logColumnModel, SpeciesFrequencyLogCellComponent.newEditor((SpeciesFrequencyUI)this.ui), SpeciesFrequencyLogCellComponent.newRender(), SpeciesFrequencyLogsTableModel.LABEL);
        SpeciesFrequencyLogsTableModel logTableModel = new SpeciesFrequencyLogsTableModel((TableColumnModelExt)logColumnModel);
        logTableModel.setRows(new ArrayList());
        logTable.setModel((TableModel)((Object)logTableModel));
        logTable.setColumnModel((TableColumnModel)logColumnModel);
        logTable.getTableHeader().setReorderingAllowed(false);
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)HighlightPredicate.ODD, (Color)this.getConfig().getColorAlternateRow());
        logTable.addHighlighter(evenHighlighter);
    }

    protected CaracteristicColumnIdentifier<IndividualObservationBatchRowModel> addCaracteristicColumnToModel(JXTable table, TableColumnModelExt columnModel, Caracteristic caracteristic) {
        String headerTip;
        String header = this.caracteristicDecorator.toString((Object)caracteristic);
        CaracteristicColumnIdentifier<IndividualObservationBatchRowModel> id = CaracteristicColumnIdentifier.newCaracteristicId(caracteristic, "defaultCaracteristics", header, headerTip = this.caracteristicTipDecorator.toString((Object)caracteristic));
        if (columnModel.getColumnExt(id) == null) {
            switch (caracteristic.getCaracteristicType()) {
                case NUMBER: {
                    this.addFloatColumnToModel((TableColumnModel)columnModel, id, "\\d{0,6}(\\.\\d{0,3})?", (JTable)table);
                    break;
                }
                case QUALITATIVE: {
                    List values = caracteristic.getQualitativeValue();
                    this.addComboDataColumnToModel((TableColumnModel)columnModel, id, this.caracteristicQualitativeDecorator, values);
                    break;
                }
                case TEXT: {
                    this.addColumnToModel((TableColumnModel)columnModel, id);
                }
            }
        }
        return id;
    }

    protected <R> TableColumnExt addColumnToModel(TableColumnModel model, TableCellEditor editor, TableCellRenderer renderer, ColumnIdentifier<R> identifier) {
        TableColumnExt col = new TableColumnExt(((DefaultTableColumnModelExt)model).getColumnCount(true));
        col.setCellEditor(editor);
        col.setCellRenderer(renderer);
        String label = I18n.t((String)identifier.getHeaderI18nKey(), (Object[])new Object[0]);
        col.setHeaderValue((Object)label);
        String tip = I18n.t((String)identifier.getHeaderTipI18nKey(), (Object[])new Object[0]);
        col.setToolTipText(tip);
        col.setIdentifier(identifier);
        model.addColumn((TableColumn)col);
        col.setSortable(false);
        return col;
    }

    protected void consumeIchtyometerFeedRecord(IchtyometerFeedReaderMeasureRecord record) {
        if (!record.isValid()) {
            this.soundEngine.beepOnExternalDeviceErrorReception();
            throw new ApplicationBusinessException(I18n.t((String)"tutti.editSpeciesFrequencies.error.itchyometer.bad.record", (Object[])new Object[]{record.getRecord()}));
        }
        float length = ((SpeciesFrequencyUIModel)((Object)this.getModel())).convertFromMm(record.getMeasure());
        this.applySpeciesFrequencyRafaleAction.applyRafaleStep(Float.valueOf(length), true);
    }

    protected void consumeCaliperFeedRecord(CaliperFeedReaderMeasureRecord record) {
        if (!record.isValid()) {
            this.soundEngine.beepOnExternalDeviceErrorReception();
            throw new ApplicationBusinessException(I18n.t((String)"tutti.editSpeciesFrequencies.error.caliper.bad.record", (Object[])new Object[]{record.getRecord()}));
        }
        float length = ((SpeciesFrequencyUIModel)((Object)this.getModel())).convertFromMm(record.getMeasure());
        this.applySpeciesFrequencyRafaleAction.applyRafaleStep(Float.valueOf(length), true);
    }

    protected void listenItchtyometer() {
        this.getContext().getIchtyometerReader().removeAllFeedModeReaderListeners();
        if (log.isInfoEnabled()) {
            log.info((Object)"Start listen ichtyometer");
        }
        this.getContext().getIchtyometerReader().addFeedModeReaderListener(this.ichtyometerFeedReaderListener);
    }

    protected void listenCaliper() {
        this.getContext().getCaliperReader().removeAllFeedModeReaderListeners();
        if (log.isInfoEnabled()) {
            log.info((Object)"Start listen caliper");
        }
        this.getContext().getCaliperReader().addFeedModeReaderListener(this.caliperFeedReaderListener);
    }

    protected JComponent getComponentToFocus(FrequencyConfigurationMode mode) {
        Object componentToFocus = null;
        if (mode != null) {
            boolean withLengthStepCaracteristic = ((SpeciesFrequencyUIModel)((Object)this.getModel())).getLengthStepCaracteristic() != null;
            switch (mode) {
                case AUTO_GEN: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((SpeciesFrequencyUI)this.ui).getMinStepField();
                        break;
                    }
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case RAFALE: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((SpeciesFrequencyUI)this.ui).getRafaleStepField();
                        break;
                    }
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case SIMPLE_COUNTING: {
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getSimpleCountingNumberField();
                    break;
                }
                default: {
                    componentToFocus = null;
                }
            }
        }
        return componentToFocus;
    }

    protected void updateLogVisibility() {
        boolean logVisible = ((SpeciesFrequencyUIModel)((Object)this.getModel())).isRafaleMode() || this.getContext().isIchtyometerConnected() || this.getContext().isCaliperConnected();
        JSplitPane firstSplitPane = ((SpeciesFrequencyUI)this.ui).getFirstSplitPane();
        JSplitPane secondSplitPane = ((SpeciesFrequencyUI)this.ui).getSecondSplitPane();
        int lastDividerLocation = secondSplitPane.getLastDividerLocation();
        if (lastDividerLocation == 0) {
            lastDividerLocation = 200;
        }
        secondSplitPane.setDividerLocation(logVisible ? lastDividerLocation : 0);
        secondSplitPane.setDividerSize(logVisible ? firstSplitPane.getDividerSize() : 0);
        ((SpeciesFrequencyUI)this.ui).getLogsScrollPane().setVisible(logVisible);
    }

    public <E> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData) {
        super.initBeanFilterableComboBox(comboBox, data, selectedData);
    }

    public SpeciesFrequencyCellComponent.FrequencyCellEditor getFrequencyEditor() {
        return this.frequencyEditor;
    }

    protected void beforeOpenPopup(int modelRowIndex, int modelColumnIndex) {
        super.beforeOpenPopup(modelRowIndex, modelColumnIndex);
        boolean sampleCodeMenusEnabled = this.individualObservationBatchTableHandler.isSampleCodeMenusEnabled(modelRowIndex);
        ((SpeciesFrequencyUI)this.ui).getEditSampleCodeMenu().setEnabled(sampleCodeMenusEnabled);
        ((SpeciesFrequencyUI)this.ui).getDeleteSampleCodeMenu().setEnabled(sampleCodeMenusEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFrequenciesAndObservations(List<SpeciesFrequencyRowModel> frequency, List<IndividualObservationBatchRowModel> individualObservations, boolean addToCache) {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)((Object)this.getModel());
        SpeciesBatchRowModel speciesBatch = model.getBatch();
        model.setInitBatchEdition(true);
        try {
            model.loadSpeciesBatch(speciesBatch);
            Species species = speciesBatch.getSpecies();
            model.setFrequenciesConfigurationMode(FrequencyConfigurationMode.RAFALE);
            SpeciesProtocol speciesProtocol = this.speciesOrBenthosBatchUISupport.getSpeciesProtocol(species);
            model.setAddIndividualObservationOnRafale(speciesProtocol != null && speciesProtocol.isIndividualObservationEnabled());
            List<SpeciesFrequencyRowModel> frequencyRows = this.getTableModel().loadRows(frequency);
            List<IndividualObservationBatchRowModel> individualObservationRows = this.individualObservationBatchTableHandler.loadRows(species, individualObservations);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will edit batch row: " + speciesBatch + " with " + frequencyRows.size() + " frequencies and " + individualObservationRows.size() + " individual observations."));
            }
            CopyIndividualObservationMode copyIndividualObservationMode = this.computeCopyIndividualObservationMode(model.isAddIndividualObservationOnRafale(), frequencyRows, individualObservationRows);
            if (log.isInfoEnabled()) {
                log.info((Object)("copyIndividualObservationMode: " + copyIndividualObservationMode));
            }
            Caracteristic lengthStepCaracteristic = this.computeLengthStepCaracteristic(species, frequencyRows, individualObservationRows);
            if (log.isInfoEnabled()) {
                log.info((Object)("lengthStepCaracteristic: " + lengthStepCaracteristic));
            }
            model.setLengthStepCaracteristic(lengthStepCaracteristic);
            FrequencyConfigurationMode configurationMode = model.guessFrequencyConfigurationMode();
            if (log.isInfoEnabled()) {
                log.info((Object)("configurationMode: " + (Object)((Object)configurationMode)));
            }
            model.setConfigurationMode(null);
            model.setConfigurationMode(configurationMode);
            model.setFrequenciesConfigurationMode(null);
            model.setFrequenciesConfigurationMode(FrequencyConfigurationMode.RAFALE);
            ((SpeciesFrequencyUI)this.ui).getValidator().setBean((Object)model);
            model.setRows(frequencyRows);
            model.setCopyIndividualObservationMode(null);
            model.setCopyIndividualObservationMode(copyIndividualObservationMode);
            this.individualObservationBatchTableHandler.loadSpeciesBatch(speciesBatch, individualObservationRows, addToCache);
            model.computeRowWeightWithRtp();
        }
        finally {
            model.setInitBatchEdition(false);
        }
    }

    protected <R> TableColumnExt addIntegerColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern, JTable table) {
        return super.addIntegerColumnToModel(model, identifier, numberPattern, table);
    }

    protected <R> TableColumnExt addFloatColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern, JTable table) {
        return super.addFloatColumnToModel(model, identifier, numberPattern, table);
    }

    @Override
    protected <R> TableColumnExt addFloatColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, WeightUnit weightUnit, JTable table) {
        return super.addFloatColumnToModel(model, identifier, weightUnit, table);
    }

    protected <R, B> TableColumnExt addComboDataColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, Decorator<B> decorator, List<B> data) {
        return super.addComboDataColumnToModel(model, identifier, decorator, data);
    }

    @Override
    protected void installTableKeyListener(TableColumnModel columnModel, JTable table, boolean enterToChangeRow) {
        super.installTableKeyListener(columnModel, table, enterToChangeRow);
    }

    protected String decorate(Serializable object, String context) {
        return super.decorate(object, context);
    }

    private CopyIndividualObservationMode computeCopyIndividualObservationMode(boolean isAddIndividualObservationOnRafale, List<SpeciesFrequencyRowModel> frequencyRows, List<IndividualObservationBatchRowModel> individualObservationRows) {
        CopyIndividualObservationMode result = CopyIndividualObservationMode.NOTHING;
        if (frequencyRows.isEmpty() && individualObservationRows.isEmpty()) {
            if (isAddIndividualObservationOnRafale) {
                result = CopyIndividualObservationMode.SIZE;
            }
        } else if (!individualObservationRows.isEmpty()) {
            IndividualObservationBatchRowModel firstIndividualObservationRow = individualObservationRows.get(0);
            result = firstIndividualObservationRow.getCopyIndividualObservationMode();
        }
        return result;
    }

    private Caracteristic computeLengthStepCaracteristic(Species species, List<SpeciesFrequencyRowModel> frequencyRows, List<IndividualObservationBatchRowModel> individualObservationRows) {
        List<SpeciesFrequencyRowModel> previousFrequency;
        Caracteristic lengthStepCaracteristic = null;
        if (!frequencyRows.isEmpty()) {
            SpeciesFrequencyRowModel firstFrequencyRow = frequencyRows.get(0);
            lengthStepCaracteristic = firstFrequencyRow.getLengthStepCaracteristic();
            if (log.isInfoEnabled()) {
                log.info((Object)("Use existing lengthStep caracteristic / step from first existing frequency: " + this.decorate((Serializable)lengthStepCaracteristic)));
            }
        }
        if (lengthStepCaracteristic == null && !individualObservationRows.isEmpty()) {
            IndividualObservationBatchRowModel firstIndividualObservationRow = individualObservationRows.get(0);
            lengthStepCaracteristic = firstIndividualObservationRow.getLengthStepCaracteristic();
            if (log.isInfoEnabled()) {
                log.info((Object)("Use existing lengthStep caracteristic / step from first individual observation : " + this.decorate((Serializable)lengthStepCaracteristic)));
            }
        }
        SpeciesBatchRowModel previousSiblingRow = this.frequencyEditor.getPreviousSiblingRow();
        if (lengthStepCaracteristic == null && previousSiblingRow != null && CollectionUtils.isNotEmpty(previousFrequency = previousSiblingRow.getFrequency())) {
            SpeciesFrequencyRowModel rowModel = previousFrequency.get(0);
            lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
            if (log.isInfoEnabled()) {
                log.info((Object)("Use previous sibling existing lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic)));
            }
        }
        if (lengthStepCaracteristic == null && this.taxonCache.containsLengthStepPmfmId(species)) {
            String lengthStepPmfmId = this.taxonCache.getLengthStepPmfmId(species);
            lengthStepCaracteristic = this.lengthStepCaracteristics.get(lengthStepPmfmId);
            if (log.isInfoEnabled()) {
                log.info((Object)("Use existing from protocol lengthStep caracteristic / step " + this.decorate((Serializable)lengthStepCaracteristic)));
            }
        }
        return lengthStepCaracteristic;
    }
}

