/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.CopyIndividualObservationMode;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.sampling.SamplingCodePrefix;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SamplingNotificationZoneModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.bean.JavaBeanObject;

public class IndividualObservationBatchUIModel
extends AbstractTuttiTableUIModel<SpeciesBatchRowModel, IndividualObservationBatchRowModel, IndividualObservationBatchUIModel>
implements JavaBeanObject {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(IndividualObservationBatchUIModel.class);
    private final SpeciesFrequencyUIModel parentModel;
    private final SamplingNotificationZoneModel samplingNotificationZoneModel;
    private final Caracteristic sexCaracteristic;
    private final List<Caracteristic> protocolIndividualObservationCaracteristics;
    private Caracteristic maturityCaracteristic;
    private Collection<Caracteristic> notEditableCaracteristic;
    protected SamplingCodePrefix samplingCodePrefix;
    private IndividualObservationBatchTableModel individualObservationTableModel;

    @Override
    protected SpeciesBatchRowModel newEntity() {
        return null;
    }

    public IndividualObservationBatchUIModel(SpeciesFrequencyUIModel parentModel, Caracteristic sexCaracteristic, List<Caracteristic> protocolIndividualObservationCaracteristics) {
        super(SpeciesBatchRowModel.class, null, null);
        this.parentModel = parentModel;
        this.sexCaracteristic = sexCaracteristic;
        this.protocolIndividualObservationCaracteristics = protocolIndividualObservationCaracteristics == null ? new ArrayList<Caracteristic>() : new ArrayList<Caracteristic>(protocolIndividualObservationCaracteristics);
        this.samplingNotificationZoneModel = new SamplingNotificationZoneModel();
    }

    public SamplingNotificationZoneModel getSamplingNotificationZoneModel() {
        return this.samplingNotificationZoneModel;
    }

    public SamplingCodePrefix getSamplingCodePrefix() {
        return this.samplingCodePrefix;
    }

    public void setSamplingCodePrefix(SamplingCodePrefix samplingCodePrefix) {
        this.samplingCodePrefix = samplingCodePrefix;
    }

    public List<Caracteristic> getProtocolIndividualObservationCaracteristics() {
        return this.protocolIndividualObservationCaracteristics;
    }

    public boolean withMaturityCaracteristic() {
        return this.maturityCaracteristic != null;
    }

    public Caracteristic getMaturityCaracteristic() {
        return this.maturityCaracteristic;
    }

    public void setMaturityCaracteristic(Caracteristic maturityCaracteristic) {
        this.maturityCaracteristic = maturityCaracteristic;
    }

    public CaracteristicQualitativeValue getMaturityValue(IndividualObservationBatchRowModel row) {
        CaracteristicQualitativeValue caracteristicValue = null;
        if (this.withMaturityCaracteristic()) {
            caracteristicValue = row.getCaracteristicQualitativeValue(this.maturityCaracteristic);
        }
        return caracteristicValue;
    }

    public CaracteristicQualitativeValue getMaturityValue(CaracteristicMap caracteristicMap) {
        CaracteristicQualitativeValue caracteristicValue = null;
        if (this.withMaturityCaracteristic()) {
            caracteristicValue = caracteristicMap.getQualitativeValue(this.maturityCaracteristic);
        }
        return caracteristicValue;
    }

    public void moveMaturityValueFromCaracteristicsToDefaultCaracteristics(IndividualObservationBatchRowModel newRow) {
        if (this.withMaturityCaracteristic()) {
            Serializable caracteristicValue = (Serializable)newRow.getCaracteristics().remove((Object)this.maturityCaracteristic);
            newRow.getDefaultCaracteristics().putIfAbsent((Object)this.maturityCaracteristic, (Object)caracteristicValue);
        }
    }

    public void setMaturityValueToDefaultCaracterictis(IndividualObservationBatchRowModel result, CaracteristicQualitativeValue maturityState) {
        result.getDefaultCaracteristics().put(this.maturityCaracteristic, (Serializable)maturityState);
    }

    public Caracteristic getSexCaracteristic() {
        return this.sexCaracteristic;
    }

    public CaracteristicQualitativeValue getGender(IndividualObservationBatchRowModel row) {
        return row.getCaracteristicQualitativeValue(this.sexCaracteristic);
    }

    public CaracteristicQualitativeValue getGender(CaracteristicMap caracteristicMap) {
        return caracteristicMap.getQualitativeValue(this.sexCaracteristic);
    }

    public void setGenderValueToDefaultCaracterictis(IndividualObservationBatchRowModel result, CaracteristicQualitativeValue gender) {
        result.getDefaultCaracteristics().put(this.sexCaracteristic, (Serializable)gender);
    }

    public void moveGenderValueFromCaracteristicsToDefaultCaracteristics(IndividualObservationBatchRowModel newRow) {
        Serializable caracteristicValue = (Serializable)newRow.getCaracteristics().remove((Object)this.sexCaracteristic);
        if (caracteristicValue != null) {
            newRow.getDefaultCaracteristics().putIfAbsent((Object)this.sexCaracteristic, (Object)caracteristicValue);
        }
    }

    public void setNotEditableCaracteristic(Collection<Caracteristic> notEditableCaracteristic) {
        this.notEditableCaracteristic = notEditableCaracteristic;
    }

    public boolean isNonEmptyRowInError() {
        return this.rowsInError.stream().anyMatch(row -> !row.isEmpty(this.notEditableCaracteristic));
    }

    public void recomputeRowsValidateState() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Revalidate all individual observation rows");
        }
        this.rowsInError.clear();
        this.rows.forEach(row -> {
            boolean valid = row.computeValid();
            row.setValid(valid);
            if (!valid) {
                this.rowsInError.add(row);
            }
        });
        this.firePropertyChange("rowsInError", null, this.rowsInError);
    }

    public boolean recomputeCanEditLengthStep() {
        boolean result = true;
        if (this.rows != null) {
            for (IndividualObservationBatchRowModel row : this.rows) {
                if (row.isEmpty(this.notEditableCaracteristic)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void recomputeRowValidState(IndividualObservationBatchRowModel row) {
        boolean valid = row.computeValid();
        row.setValid(valid);
        if (valid) {
            this.removeRowInError(row);
        } else {
            this.addRowInError(row);
        }
    }

    public void setCopyIndividualObservationMode(CopyIndividualObservationMode newCopyMode) {
        this.getRows().forEach(row -> row.setCopyIndividualObservationMode(newCopyMode));
        this.recomputeRowsValidateState();
        this.individualObservationTableModel.fireTableDataChanged();
    }

    public void removeIndividualObservations(Collection<IndividualObservationBatchRowModel> rows) {
        this.parentModel.getIndividualObservationUICache().removeIndividualObservations(rows);
        this.parentModel.getSamplingCodeUICache().removeIndividualObservations(rows);
        ArrayList newRows = new ArrayList(this.getRows());
        newRows.removeAll(rows);
        this.setRows(newRows);
    }

    public void setIndividualObservationTableModel(IndividualObservationBatchTableModel individualObservationTableModel) {
        this.individualObservationTableModel = individualObservationTableModel;
    }

    public void clear() {
        this.removeIndividualObservations(this.rows);
    }
}

