/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit;

import com.google.common.io.Files;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.ImportPupitriPopupUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.ImportPupitriPopupUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public class ImportPupitriPopupUIHandler
extends AbstractTuttiUIHandler<ImportPupitriPopupUIModel, ImportPupitriPopupUI> {
    private static final Log log = LogFactory.getLog(ImportPupitriPopupUIHandler.class);

    public void beforeInit(ImportPupitriPopupUI ui) {
        super.beforeInit((ApplicationUI)ui);
        ImportPupitriPopupUIModel model = new ImportPupitriPopupUIModel();
        boolean pupitriImportMissingBatches = this.getConfig().getPupitriImportMissingBatches();
        model.setImportMissingBatches(pupitriImportMissingBatches);
        ui.setContextValue(model);
    }

    public void afterInit(ImportPupitriPopupUI ui) {
        this.initUI(ui);
        ui.getTrunkFile().setDialogOwner((JDialog)ui);
        ui.getCarrouselFile().setDialogOwner((JDialog)ui);
        ui.pack();
        ui.setResizable(true);
        ((ImportPupitriPopupUIModel)((Object)this.getModel())).addPropertyChangeListener("trunkFile", evt -> this.updateCarrouselFile());
        ((ImportPupitriPopupUIModel)((Object)this.getModel())).addPropertyChangeListener("carrouselFile", evt -> this.updateTrunkFile());
    }

    protected JComponent getComponentToFocus() {
        return ((ImportPupitriPopupUI)this.ui).getTrunkFile();
    }

    public void onCloseUI() {
        this.resetFields();
    }

    public SwingValidator<ImportPupitriPopupUIModel> getValidator() {
        return null;
    }

    protected void updateTrunkFile() {
        File carrouselFile = ((ImportPupitriPopupUIModel)((Object)this.getModel())).getCarrouselFile();
        if (carrouselFile != null) {
            String nameWithoutExtension = Files.getNameWithoutExtension((String)carrouselFile.getName());
            File trunkFile = new File(carrouselFile.getParentFile(), nameWithoutExtension + ".tnk");
            if (trunkFile.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Select from carrousel file, trunk file: " + trunkFile));
                }
                ((ImportPupitriPopupUIModel)((Object)this.getModel())).setTrunkFile(trunkFile);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No trunk file at " + trunkFile));
            }
        }
    }

    protected void updateCarrouselFile() {
        File trunkFile = ((ImportPupitriPopupUIModel)((Object)this.getModel())).getTrunkFile();
        if (trunkFile != null) {
            String nameWithoutExtension = Files.getNameWithoutExtension((String)trunkFile.getName());
            File carrouselFile = new File(trunkFile.getParentFile(), nameWithoutExtension + ".car");
            if (carrouselFile.exists()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Select from trunk file, carrousel file: " + carrouselFile));
                }
                ((ImportPupitriPopupUIModel)((Object)this.getModel())).setCarrouselFile(carrouselFile);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No carrousel file at " + carrouselFile));
            }
        }
    }

    public void open() {
        this.resetFields();
        SwingUtil.center((Component)TuttiUIUtil.getApplicationContext((JAXXObject)this.ui).getMainUI(), (Component)((Component)this.ui));
        ((ImportPupitriPopupUI)this.ui).setVisible(true);
    }

    public void resetFields() {
        ((ImportPupitriPopupUI)this.ui).getTrunkFile().setSelectedFilePath(null);
        ((ImportPupitriPopupUI)this.ui).getCarrouselFile().setSelectedFilePath(null);
    }
}

