/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.actions;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaveCatchBatchAction
extends LongActionSupport<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    private static final Log log = LogFactory.getLog(SaveCatchBatchAction.class);
    protected boolean updateUI;

    public SaveCatchBatchAction(EditCatchesUIHandler handler) {
        super(handler, true);
    }

    public void setUpdateUI(boolean updateUI) {
        this.updateUI = updateUI;
    }

    public void releaseAction() {
        this.updateUI = true;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        boolean mustSave;
        TuttiBeanMonitor<EditCatchesUIModel> monitor = ((EditCatchesUIHandler)this.handler).getCatchBatchMonitor();
        EditCatchesUIModel beanToSave = monitor.getBean();
        boolean bl = mustSave = (beanToSave.isCreate() || beanToSave.isModify()) && beanToSave.isValid();
        if (mustSave) {
            PersistenceService persistenceService = this.getContext().getPersistenceService();
            CatchBatch catchBatch = beanToSave.toEntity();
            if (log.isInfoEnabled()) {
                log.info((Object)("FishingOperation " + catchBatch.getId() + " was modified, will save it."));
            }
            this.sendMessage("[ Captures - Caract\u00e9ristiques g\u00e9n\u00e9rales ] Sauvegarde des modifications du r\u00e9sum\u00e9 de la capture.");
            persistenceService.saveCatchBatch(catchBatch);
            monitor.clearModified();
            ((EditCatchesUIModel)this.getModel()).setModify(false);
        }
        ((EditCatchesUI)this.getUI()).getSpeciesTabPanel().getEditBatchesUI().getHandler().clearTableSelection();
        ((EditCatchesUI)this.getUI()).getBenthosTabPanel().getEditBatchesUI().getHandler().clearTableSelection();
    }
}

