/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatchDao;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationException;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidator;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationDao;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.TuttiCatchBatchValidator;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Component;

@Component(value="batchPersistenceHelper")
public class BatchPersistenceHelper
extends AbstractPersistenceService {
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="individualObservationBatchPersistenceService")
    protected IndividualObservationBatchPersistenceService individualObservationBatchPersistenceService;
    @Resource(name="accidentalBatchPersistenceService")
    protected AccidentalBatchPersistenceService accidentalBatchService;
    @Resource(name="catchBatchDao")
    protected CatchBatchExtendDao catchBatchDao;
    @Resource(name="sortingBatchDao")
    protected SortingBatchDao sortingBatchDao;
    @Resource(name="fishingOperationDao")
    protected FishingOperationDao fishingOperationDao;
    @Resource(name="scientificCruiseCatchBatchValidator")
    protected TuttiCatchBatchValidator catchBatchValidator;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;

    @Override
    public void init() {
        super.init();
        this.catchBatchDao.registerCatchBatchValidator((CatchBatchValidator)this.catchBatchValidator);
    }

    @Override
    public void close() {
        this.catchBatchDao.unregisterCatchBatchValidator((CatchBatchValidator)this.catchBatchValidator);
        super.close();
    }

    public CatchBatch createCatchBatch(CatchBatch bean, fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch) {
        catchBatch = this.catchBatchDao.create(catchBatch);
        bean.setId(catchBatch.getId());
        return bean;
    }

    public void validateSpecies(SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> species) throws InvalidBatchModelException {
        List<CatchBatchValidationError> errors = this.catchBatchValidator.validateSpecies(sampleCategoryModel, species);
        ArrayList errorsStr = Lists.newArrayList();
        errorsStr.addAll(errors.stream().filter(error -> error.getGravity() == 2).map(CatchBatchValidationError::getMessage).collect(Collectors.toList()));
        if (!errorsStr.isEmpty()) {
            String join = Joiner.on((String)"<br/>").join((Iterable)errorsStr);
            throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.batch.validation.bad.sample.categories", (Object[])new Object[]{join}));
        }
    }

    public void validateBenthos(SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> benthos) throws InvalidBatchModelException {
        List<CatchBatchValidationError> errors = this.catchBatchValidator.validateBenthos(sampleCategoryModel, benthos);
        if (CollectionUtils.isNotEmpty(errors)) {
            ArrayList errorsStr = Lists.newArrayList();
            errorsStr.addAll(errors.stream().filter(error -> error.getGravity() == 2).map(CatchBatchValidationError::getMessage).collect(Collectors.toList()));
            if (!errorsStr.isEmpty()) {
                String join = Joiner.on((String)"<br/>").join((Iterable)errorsStr);
                throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.batch.validation.bad.sample.categories", (Object[])new Object[]{join}));
            }
        }
    }

    public void deleteCatchBatch(Integer fishingOperationId, Integer catchBatchId) {
        this.accidentalBatchService.deleteAccidentalBatchForFishingOperation(fishingOperationId);
        this.getCurrentSession().flush();
        this.individualObservationBatchPersistenceService.deleteAllIndividualObservationsForFishingOperation(fishingOperationId);
        this.getCurrentSession().flush();
        FishingOperation fishingOperation = this.fishingOperationDao.load(fishingOperationId);
        this.synchronizationStatusHelper.setDirty(fishingOperation.getFishingTrip());
        Set<Integer> ids = this.getBatchIds(catchBatchId);
        ids.remove(catchBatchId);
        this.catchBatchDao.remove(catchBatchId);
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.CATCH_BATCH, catchBatchId);
        this.getCurrentSession().flush();
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.BATCH, ids);
    }

    public <D extends TuttiEntity> D createSortingBatch(D bean, fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch, SortingBatch batch) {
        this.synchronizationStatusHelper.setDirty(catchBatch);
        batch = this.catchBatchDao.createSortingBatch(batch, catchBatch);
        bean.setId(batch.getId());
        return bean;
    }

    public Set<Integer> getBatchIds(Integer batchId) {
        HashSet ids = Sets.newHashSet((Iterable)this.catchBatchDao.getAllChildrenIds(batchId));
        ids.add(batchId);
        return ids;
    }

    public void removeWithChildren(Integer batchId) {
        this.individualObservationBatchPersistenceService.deleteAllIndividualObservationsForBatch(batchId);
        Set<Integer> ids = this.getBatchIds(batchId);
        this.catchBatchDao.removeWithChildren(batchId);
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.BATCH, ids);
    }

    public void removeWithChildren(Integer batchId, fr.ifremer.adagio.core.dao.data.batch.CatchBatch parentCatchBatch) {
        this.individualObservationBatchPersistenceService.deleteAllIndividualObservationsForBatch(batchId);
        Set<Integer> ids = this.getBatchIds(batchId);
        this.catchBatchDao.removeWithChildren(batchId, parentCatchBatch);
        this.attachmentPersistenceService.deleteAllAttachment(ObjectTypeCode.BATCH, ids);
    }

    public void updateSortingBatch(List<SortingBatch> sortingBatchs, fr.ifremer.adagio.core.dao.data.batch.CatchBatch parentCatchBatch) {
        this.catchBatchDao.updateSortingBatch(sortingBatchs, parentCatchBatch);
    }

    public SortingBatch loadSortingBatch(Integer sortingBatchId, fr.ifremer.adagio.core.dao.data.batch.CatchBatch parentCatchBatch) {
        return this.catchBatchDao.loadSortingBatch(sortingBatchId, parentCatchBatch);
    }

    public void update(fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch) {
        this.catchBatchDao.update(catchBatch);
    }

    public SortingBatch getSortingBatchById(fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch, Integer sortingBatchId) {
        return this.catchBatchDao.getSortingBatchById(catchBatch, sortingBatchId);
    }

    public void updateSortingBatch(SortingBatch sortingBatch, fr.ifremer.adagio.core.dao.data.batch.CatchBatch parentCatchBatch) {
        this.synchronizationStatusHelper.setDirty(parentCatchBatch);
        this.catchBatchDao.updateSortingBatch(sortingBatch, parentCatchBatch);
    }

    public fr.ifremer.adagio.core.dao.data.batch.CatchBatch getRootCatchBatchByFishingOperationId(Integer fishingOperationId, boolean validate) {
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch result;
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.catchBatchDao.getIdByFishingOperationId(fishingOperationId);
        Preconditions.checkNotNull((Object)catchBatchId);
        if (validate) {
            try {
                result = this.catchBatchDao.loadFullTree(catchBatchId, PmfmId.WEIGHT_MEASURED.getValue(), true, false);
            }
            catch (CatchBatchValidationException e) {
                throw new InvalidBatchModelException("L'arbre d'\u00e9chantillonage n'est pas compatible avec celui de Tutti.", e);
            }
        } else {
            result = this.catchBatchDao.loadFullTree(catchBatchId, PmfmId.WEIGHT_MEASURED.getValue());
        }
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public boolean isCatchBatchExistsForFishingOperation(Integer fishingOperationId) {
        return this.catchBatchDao.isCatchBatchExistsForFishingOperation(fishingOperationId);
    }

    public Integer getCatchBatchIdByFishingOperationId(Integer fishingOperationId) throws DataRetrievalFailureException {
        return this.catchBatchDao.getIdByFishingOperationId(fishingOperationId);
    }

    public fr.ifremer.adagio.core.dao.data.batch.CatchBatch getRootCatchBatchByBatchId(Integer batchId) {
        Preconditions.checkNotNull((Object)batchId);
        Integer catchBatchId = this.catchBatchDao.getIdBySortingBatchId(batchId);
        Preconditions.checkNotNull((Object)catchBatchId);
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch result = this.catchBatchDao.loadFullTree(catchBatchId, PmfmId.WEIGHT_MEASURED.getValue());
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public void setSortingBatchReferenceTaxon(Integer batchId, Species species) {
        this.catchBatchDao.setSortingBatchReferenceTaxon(String.valueOf(batchId), species.getReferenceTaxonId());
    }

    public short computeRankOrder(SortingBatch target) {
        short rankOrder = 1;
        if (target.getParentBatch() != null && target.getParentBatch().getChildBatchs() != null) {
            short maxRankOrder = 0;
            for (Batch batch : target.getParentBatch().getChildBatchs()) {
                Short r = batch.getRankOrder();
                if (r == null || r <= maxRankOrder) continue;
                maxRankOrder = r;
            }
            rankOrder = (short)(rankOrder + maxRankOrder);
        }
        return rankOrder;
    }

    public void deleteBatch(Integer batchId) {
        Preconditions.checkNotNull((Object)batchId);
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch = this.getRootCatchBatchByBatchId(batchId);
        this.synchronizationStatusHelper.setDirty(catchBatch);
        this.removeWithChildren(batchId);
    }
}

