/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportTechnicalActionSupport;
import java.util.LinkedHashSet;

public class LoadDataAction
extends ExportTechnicalActionSupport {
    private final PersistenceService persistenceService;

    public LoadDataAction(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public void execute(GenericFormatExportContext exportContext) {
        ProgramDataModel dataToExport = exportContext.getDataToExport();
        for (CruiseDataModel cruiseDataModel : dataToExport) {
            Cruise cruise = this.persistenceService.getCruise(cruiseDataModel.getIdAsInt());
            Preconditions.checkNotNull((Object)cruise);
            LinkedHashSet<FishingOperation> operations = new LinkedHashSet<FishingOperation>();
            for (OperationDataModel operationDataModel : cruiseDataModel) {
                FishingOperation operation = this.persistenceService.getFishingOperation(operationDataModel.getIdAsInt());
                operations.add(operation);
            }
            exportContext.addCruiseContext(cruise, operations);
        }
    }
}

