/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.util.List;
import org.jdesktop.beans.AbstractSerializableBean;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.nuiton.i18n.I18n;

public class AverageWeightsHistogramModel
extends AbstractSerializableBean {
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_LENGTH_STEP_LABEL_WITH_UNIT = "lengthStepLabelWithUnit";
    public static final String PROPERTY_STEP = "step";
    private final XYSeriesCollection dataset;
    protected final XYSeries series;
    private final WeightUnit frequencyWeightUnit;
    private String title;
    private String lengthStepLabelWithUnit;
    private Float step;

    public AverageWeightsHistogramModel(WeightUnit frequencyWeightUnit) {
        this.frequencyWeightUnit = frequencyWeightUnit;
        this.series = new XYSeries((Comparable)((Object)""), true, false);
        this.dataset = new XYSeriesCollection(this.series);
        this.dataset.setIntervalPositionFactor(0.0);
        this.dataset.setIntervalWidth(0.0);
    }

    public WeightUnit getFrequencyWeightUnit() {
        return this.frequencyWeightUnit;
    }

    public XYSeriesCollection getDataset() {
        return this.dataset;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        title = title + this.frequencyWeightUnit.decorateLabel(I18n.t((String)"tutti.editSpeciesFrequencies.field.graphAverageWeight", (Object[])new Object[0]));
        String oldValue = this.getTitle();
        this.title = title;
        this.firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    public String getLengthStepLabelWithUnit() {
        return this.lengthStepLabelWithUnit;
    }

    public void setLengthStepLabelWithUnit(String lengthStepLabelWithUnit) {
        String oldValue = this.getLengthStepLabelWithUnit();
        this.lengthStepLabelWithUnit = lengthStepLabelWithUnit;
        this.firePropertyChange(PROPERTY_LENGTH_STEP_LABEL_WITH_UNIT, oldValue, lengthStepLabelWithUnit);
    }

    public Float getStep() {
        return this.step;
    }

    public void setStep(Float step) {
        Float oldValue = this.getStep();
        this.step = step;
        this.firePropertyChange(PROPERTY_STEP, oldValue, step);
    }

    public void reloadRows(List<SpeciesFrequencyRowModel> rows) {
        this.series.clear();
        if (rows != null) {
            rows.stream().filter(AbstractTuttiBeanUIModel::isValid).forEach(this::addOrUpdate);
        }
    }

    public void addOrUpdate(SpeciesFrequencyRowModel row) {
        this.series.addOrUpdate((Number)row.getLengthStep(), (Number)row.computeAverageWeight());
    }

    public void removeValue(Float lengthStep) {
        if (this.series.indexOf((Number)lengthStep) >= 0) {
            if (this.series.getItemCount() > 1) {
                this.series.remove((Number)lengthStep);
            } else {
                this.series.clear();
            }
        }
    }
}

