/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.widgets.number.NumberEditor;

public class SampleCategoryComponent {
    public static <C extends Serializable> TableCellRenderer newRender(TableCellRenderer renderer, Decorator<C> decorator, Color computedDataColor, WeightUnit weightUnit) {
        return new SampleCategoryRenderer<C>(renderer, decorator, computedDataColor, weightUnit);
    }

    public static <C extends Serializable> TableCellEditor newEditor(Decorator<C> decorator, WeightUnit weightUnit) {
        return new SampleCategoryEditor<C>(decorator, weightUnit);
    }

    public static class SampleCategoryRenderer<C extends Serializable>
    implements TableCellRenderer {
        protected final TableCellRenderer delegate;
        protected final Decorator<C> categoryDecorator;
        protected final Color computedWeightColor;
        protected final WeightUnit weightUnit;
        JPanel editor;
        JLabel editorLabel;
        JLabel editorValue;

        public SampleCategoryRenderer(TableCellRenderer delegate, Decorator<C> categoryDecorator, Color computedWeightColor, WeightUnit weightUnit) {
            this.delegate = delegate;
            this.categoryDecorator = categoryDecorator;
            this.computedWeightColor = computedWeightColor;
            this.weightUnit = weightUnit;
            this.editor = new JPanel();
            this.editor.setOpaque(true);
            this.editorLabel = new JLabel();
            this.editorValue = new JLabel();
            this.editor.setLayout(new BorderLayout());
            this.editor.add((Component)this.editorLabel, "Center");
            this.editor.add((Component)this.editorValue, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String valueText;
            SampleCategory sampleCategory = (SampleCategory)value;
            String prefixText = this.getPrefixText(sampleCategory);
            this.editorLabel.setText(prefixText);
            String valueTextHtml = valueText = this.getValueText(sampleCategory);
            if (isSelected) {
                valueTextHtml = String.format("<strong>%s</strong>", valueTextHtml);
                this.editorLabel.setFont(table.getFont().deriveFont(1));
            } else {
                this.editorLabel.setFont(table.getFont());
            }
            valueTextHtml = String.format("<html>%s</html>", valueTextHtml);
            this.editorValue.setText(valueTextHtml);
            String tip = null;
            if (StringUtils.isNotBlank((CharSequence)prefixText)) {
                tip = String.format("<span style='white-space: nowrap;'>%s</span> %s", prefixText, valueText);
                if (isSelected) {
                    tip = String.format("<strong>%s</strong>", tip);
                }
                tip = String.format("<html>%s</html>", tip);
            }
            this.editor.setToolTipText(tip);
            return this.editor;
        }

        protected String getPrefixText(SampleCategory<C> sampleCategory) {
            Serializable categoryValue;
            String text = null;
            if (sampleCategory != null && (categoryValue = sampleCategory.getCategoryValue()) != null) {
                text = this.categoryDecorator.toString((Object)categoryValue) + " /";
                if (sampleCategory.isSubSample()) {
                    text = text + "/";
                }
            }
            return text == null ? "" : text;
        }

        protected String getValueText(SampleCategory<C> sampleCategory) {
            Serializable categoryValue;
            String text = "";
            if (sampleCategory != null && (categoryValue = sampleCategory.getCategoryValue()) != null) {
                Float number = sampleCategory.getCategoryWeight();
                Float computedNumber = sampleCategory.getComputedWeight();
                if (number != null) {
                    text = text + this.weightUnit.renderWeight(number);
                } else if (computedNumber != null) {
                    String weightStr = this.weightUnit.renderWeight(computedNumber);
                    if (sampleCategory.hasOnlyOneFrequency()) {
                        text = text + weightStr;
                    } else {
                        String color = Integer.toHexString(this.computedWeightColor.getRGB()).substring(2);
                        text = text + "<em style='color: #" + color + "'>" + weightStr + "</em>";
                    }
                } else {
                    text = text + "-";
                }
            }
            return text;
        }
    }

    public static class SampleCategoryEditor<C extends Serializable>
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusListener,
    AncestorListener {
        private static final long serialVersionUID = 1L;
        protected final NumberEditor numberEditor;
        protected final JPanel editor;
        protected final JLabel editorLabel;
        protected final Decorator<C> categoryDecorator;
        private final WeightUnit weightUnit;

        public SampleCategoryEditor(Decorator<C> categoryDecorator, WeightUnit weightUnit) {
            this.categoryDecorator = categoryDecorator;
            this.weightUnit = weightUnit;
            this.numberEditor = new NumberEditor();
            this.numberEditor.getTextField().setHorizontalAlignment(4);
            this.numberEditor.getTextField().setBorder(null);
            this.numberEditor.getTextField().addFocusListener(this);
            this.numberEditor.getTextField().addAncestorListener(this);
            this.numberEditor.setNumberType(Float.class);
            this.numberEditor.setUseSign(false);
            this.numberEditor.setNumberPattern(weightUnit.getNumberEditorPattern());
            this.numberEditor.init();
            this.editor = new JPanel(new BorderLayout());
            this.editorLabel = new JLabel();
            this.editor.add("West", this.editorLabel);
            this.editor.add("Center", (Component)this.numberEditor);
            this.editor.setOpaque(true);
            this.editorLabel.setOpaque(true);
        }

        public NumberEditor getNumberEditor() {
            return this.numberEditor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String label;
            SampleCategory sampleCategory = (SampleCategory)value;
            Serializable categoryValue = sampleCategory == null ? null : sampleCategory.getCategoryValue();
            Float number = sampleCategory == null ? null : sampleCategory.getCategoryWeight();
            this.numberEditor.setNumberValue((Number)number);
            if (number == null) {
                this.numberEditor.getModel().setTextValue("");
            } else {
                this.numberEditor.getModel().setTextValue(this.weightUnit.renderWeight(number));
            }
            String string = label = sampleCategory == null ? "-" : this.categoryDecorator.toString((Object)categoryValue);
            if (isSelected) {
                this.editorLabel.setFont(table.getFont().deriveFont(1));
                this.editorLabel.setBackground(TuttiUIContext.getApplicationContext().getConfig().getColorSelectedRow());
            } else {
                this.editorLabel.setFont(table.getFont());
                this.editorLabel.setBackground(null);
            }
            this.editorLabel.setText(label);
            return this.editor;
        }

        @Override
        public Float getCellEditorValue() {
            return (Float)this.numberEditor.getModel().getNumberValue();
        }

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    numberEditor.getTextField().requestFocus();
                    numberEditor.getTextField().selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    numberEditor.getTextField().requestFocus();
                    numberEditor.getTextField().selectAll();
                }
            });
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public boolean stopCellEditing() {
            boolean result = super.stopCellEditing();
            if (result) {
                this.resetEditor();
            }
            return result;
        }

        @Override
        public void cancelCellEditing() {
            this.resetEditor();
            super.cancelCellEditing();
        }

        protected void resetEditor() {
            this.numberEditor.setNumberValue(null);
            this.numberEditor.getModel().setTextValue("");
            this.editorLabel.setText("-");
        }
    }
}

