/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.BatchSavedEvent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.BatchSavedListener;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.sort.TableSortController;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

public abstract class AbstractTuttiBatchTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiBatchUIModel<R, M>, T extends AbstractApplicationTableModel<R>, UI extends TuttiUI<M, ?>>
extends AbstractTuttiTableUIHandler<R, M, UI> {
    protected final List<BatchSavedListener> batchSavedListeners = new ArrayList<BatchSavedListener>();

    protected abstract ColumnIdentifier<R> getCommentIdentifier();

    protected abstract ColumnIdentifier<R> getAttachementIdentifier();

    public abstract void selectFishingOperation(FishingOperation var1);

    protected AbstractTuttiBatchTableUIHandler(String ... properties) {
        super(properties);
    }

    public final void clearTableSelection() {
        JXTable table = this.getTable();
        if (table.isEditing()) {
            table.editingCanceled(null);
        }
        table.clearSelection();
    }

    public void addBatchSavedListener(BatchSavedListener listener) {
        this.batchSavedListeners.add(listener);
    }

    public void removeBatchSavedListener(BatchSavedListener listener) {
        this.batchSavedListeners.remove(listener);
    }

    public void fireBatchSaved(R row) {
        for (BatchSavedListener listener : this.batchSavedListeners) {
            listener.onBatchSaved(new BatchSavedEvent((AbstractTuttiBatchUIModel)((Object)this.getModel()), (AbstractTuttiBeanUIModel)((Object)row)));
        }
    }

    @Override
    protected void onRowModified(int rowIndex, R row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        this.saveSelectedRowIfNeeded();
    }

    protected void initBatchTable(JXTable table, TableColumnModelExt columnModel, T tableModel) {
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        TableSortController sorter = new TableSortController(tableModel);
        sorter.setSortable(false);
        table.setRowSorter((RowSorter)sorter);
        this.initTable(table);
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        this.addCommentHighlighter(table, this.getCommentIdentifier());
        this.addAttachementHighlighter(table, this.getAttachementIdentifier());
    }

    protected void addCommentHighlighter(JXTable table, ColumnIdentifier identifier) {
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{identifier}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String value = (String)adapter.getValue();
                return StringUtils.isNotBlank((CharSequence)value);
            }
        }}), (Color)cellWithValueColor);
        table.addHighlighter(commentHighlighter);
    }

    protected void addAttachementHighlighter(JXTable table, ColumnIdentifier identifier) {
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{identifier}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Collection attachments = (Collection)adapter.getValue();
                return CollectionUtils.isNotEmpty((Collection)attachments);
            }
        }}), (Color)cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
    }

    protected void addIdColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, JTable table) {
        final TableCellRenderer defaultRenderer = table.getDefaultRenderer(Number.class);
        final Decorator<String> idDecorator = this.getDecorator(String.class, "spaceEvery3Digit");
        TableCellRenderer idTableCellRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component result;
                String text = null;
                if (value != null) {
                    text = idDecorator.toString(value);
                }
                if ((result = defaultRenderer.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column)) instanceof JLabel) {
                    JLabel jLabel = (JLabel)result;
                    jLabel.setHorizontalTextPosition(4);
                }
                return result;
            }
        };
        this.addColumnToModel(model, null, idTableCellRenderer, identifier);
    }
}

