package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2016 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import static org.nuiton.i18n.I18n.t;

public class IndividualObservationBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<IndividualObservationBatchUIModel, IndividualObservationBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REMOVE_ALL_INDIVIDUAL_OBSERVATION_BATCH_MENU_ENABLED = "removeAllIndividualObservationBatchMenu.enabled";
    public static final String BINDING_REMOVE_INDIVIDUAL_OBSERVATION_BATCH_MENU_ENABLED = "removeIndividualObservationBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(IndividualObservationBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton createIndividualObservationBatchButton;
    protected IndividualObservationBatchUI editIndividualObservationBatchTopPanel = this;
    protected JMenuItem exportMultiPostButton;
    protected final IndividualObservationBatchUIHandler handler = createHandler();
    protected JMenuItem importMultiPostButton;
    protected ButtonAttachment individualObservationBatchAttachmentsButton;
    protected JToolBar individualObservationBatchTabToolBar;
    protected JMenuBar menu;
    protected JMenu menuAction;
    protected IndividualObservationBatchUIModel model;
    protected JMenuItem removeAllIndividualObservationBatchMenu;
    protected JMenuItem removeIndividualObservationBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<IndividualObservationBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IndividualObservationBatchUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public IndividualObservationBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public IndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IndividualObservationBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public IndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IndividualObservationBatchUI() {
        $initialize();
    }

    public IndividualObservationBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public IndividualObservationBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public IndividualObservationBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateIndividualObservationBatchButton() {
        return createIndividualObservationBatchButton;
    }

    public JMenuItem getExportMultiPostButton() {
        return exportMultiPostButton;
    }

    public IndividualObservationBatchUIHandler getHandler() {
        return handler;
    }

    public JMenuItem getImportMultiPostButton() {
        return importMultiPostButton;
    }

    public ButtonAttachment getIndividualObservationBatchAttachmentsButton() {
        return individualObservationBatchAttachmentsButton;
    }

    public JToolBar getIndividualObservationBatchTabToolBar() {
        return individualObservationBatchTabToolBar;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuAction() {
        return menuAction;
    }

    public IndividualObservationBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveAllIndividualObservationBatchMenu() {
        return removeAllIndividualObservationBatchMenu;
    }

    public JMenuItem getRemoveIndividualObservationBatchMenu() {
        return removeIndividualObservationBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<IndividualObservationBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditIndividualObservationBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(individualObservationBatchTabToolBar);
        add(tableToolbar, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToIndividualObservationBatchTabToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        individualObservationBatchTabToolBar.add(menu);
        individualObservationBatchTabToolBar.add(individualObservationBatchAttachmentsButton);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuAction);
    }

    protected void addChildrenToMenuAction() {
        if (!allComponentsCreated) {
            return;
        }
        menuAction.add(importMultiPostButton);
        menuAction.add(exportMultiPostButton);
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(removeIndividualObservationBatchMenu);
        tablePopup.add(removeAllIndividualObservationBatchMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editIndividualObservationBatch.help"));
    }

    protected void createCreateIndividualObservationBatchButton() {
        $objectMap.put("createIndividualObservationBatchButton", createIndividualObservationBatchButton = new JButton());
        
        createIndividualObservationBatchButton.setName("createIndividualObservationBatchButton");
        createIndividualObservationBatchButton.setText(t("tutti.editIndividualObservationBatch.action.createBatch"));
        createIndividualObservationBatchButton.setToolTipText(t("tutti.editIndividualObservationBatch.action.createBatch.tip"));
        createIndividualObservationBatchButton.putClientProperty("help", "tutti.editIndividualObservationBatch.action.createBatch.help");
        createIndividualObservationBatchButton.putClientProperty("simpleAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.actions.OpenCreateIndividualObservationBatchUIAction.class);
    }

    protected void createExportMultiPostButton() {
        $objectMap.put("exportMultiPostButton", exportMultiPostButton = new JMenuItem());
        
        exportMultiPostButton.setName("exportMultiPostButton");
        exportMultiPostButton.setText(t("tutti.editIndividualObservationBatch.action.exportMultiPost"));
        exportMultiPostButton.setToolTipText(t("tutti.editIndividualObservationBatch.action.exportMultiPost.tip"));
        exportMultiPostButton.putClientProperty("help", "tutti.editIndividualObservationBatch.action.exportMultiPost.help");
        exportMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.actions.ExportMultiPostIndividualObservationAction.class);
    }

    protected IndividualObservationBatchUIHandler createHandler() {
        return new IndividualObservationBatchUIHandler();
    }

    protected void createImportMultiPostButton() {
        $objectMap.put("importMultiPostButton", importMultiPostButton = new JMenuItem());
        
        importMultiPostButton.setName("importMultiPostButton");
        importMultiPostButton.setText(t("tutti.editIndividualObservationBatch.action.importMultiPost"));
        importMultiPostButton.setToolTipText(t("tutti.editIndividualObservationBatch.action.importMultiPost.tip"));
        importMultiPostButton.putClientProperty("help", "tutti.editIndividualObservationBatch.action.importMultiPost.help");
        importMultiPostButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.actions.ImportMultiPostIndividualObservationAction.class);
    }

    protected void createIndividualObservationBatchAttachmentsButton() {
        $objectMap.put("individualObservationBatchAttachmentsButton", individualObservationBatchAttachmentsButton = new ButtonAttachment(handler.getContext(), getContextValue(EditCatchesUIModel.class)));
        
        individualObservationBatchAttachmentsButton.setName("individualObservationBatchAttachmentsButton");
        individualObservationBatchAttachmentsButton.setToolTipText(t("tutti.editIndividualObservationBatch.action.attachments.tip"));
        individualObservationBatchAttachmentsButton.setFocusPainted(false);
    }

    protected void createIndividualObservationBatchTabToolBar() {
        $objectMap.put("individualObservationBatchTabToolBar", individualObservationBatchTabToolBar = new JToolBar());
        
        individualObservationBatchTabToolBar.setName("individualObservationBatchTabToolBar");
        individualObservationBatchTabToolBar.setBorderPainted(false);
        individualObservationBatchTabToolBar.setOpaque(true);
        individualObservationBatchTabToolBar.setFloatable(false);
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuAction() {
        $objectMap.put("menuAction", menuAction = new JMenu());
        
        menuAction.setName("menuAction");
        menuAction.setOpaque(true);
        menuAction.setText(t("tutti.toolbar.menu.action"));
        menuAction.setToolTipText(t("tutti.toolbar.menu.action.tip"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(IndividualObservationBatchUIModel.class));
    }

    protected void createRemoveAllIndividualObservationBatchMenu() {
        $objectMap.put("removeAllIndividualObservationBatchMenu", removeAllIndividualObservationBatchMenu = new JMenuItem());
        
        removeAllIndividualObservationBatchMenu.setName("removeAllIndividualObservationBatchMenu");
        removeAllIndividualObservationBatchMenu.setText(t("tutti.editIndividualObservationBatch.action.removeAllBatch"));
        removeAllIndividualObservationBatchMenu.setToolTipText(t("tutti.editIndividualObservationBatch.action.removeAllBatch.tip"));
        removeAllIndividualObservationBatchMenu.putClientProperty("help", "tutti.editIndividualObservationBatch.action.removeAllBatch.help");
        removeAllIndividualObservationBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.actions.RemoveAllIndividualObservationBatchAction.class);
    }

    protected void createRemoveIndividualObservationBatchMenu() {
        $objectMap.put("removeIndividualObservationBatchMenu", removeIndividualObservationBatchMenu = new JMenuItem());
        
        removeIndividualObservationBatchMenu.setName("removeIndividualObservationBatchMenu");
        removeIndividualObservationBatchMenu.setText(t("tutti.editIndividualObservationBatch.action.removeBatch"));
        removeIndividualObservationBatchMenu.setToolTipText(t("tutti.editIndividualObservationBatch.action.removeBatch.tip"));
        removeIndividualObservationBatchMenu.putClientProperty("help", "tutti.editIndividualObservationBatch.action.removeBatch.help");
        removeIndividualObservationBatchMenu.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.actions.RemoveIndividualObservationBatchAction.class);
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editIndividualObservationBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
        SwingUtil.setComponentHeight(tableToolbar,50);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(IndividualObservationBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditIndividualObservationBatchTopPanel();
        addChildrenToValidator();
        addChildrenToIndividualObservationBatchTabToolBar();
        addChildrenToMenu();
        addChildrenToMenuAction();
        addChildrenToTablePopup();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createIndividualObservationBatchButton);
        addChildrenToTableScrollPane();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        menu.setBorder(null);
        menu.setBackground(javax.swing.UIManager.getColor("MenuBar.background"));
        menuAction.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.toolbar.menu.action.mnemonic"),'Z'));
        importMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editIndividualObservationBatch.action.importMultiPost.mnemonic"),'Z'));
        importMultiPostButton.setIcon(SwingUtil.createActionIcon("import"));
        exportMultiPostButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editIndividualObservationBatch.action.exportMultiPost.mnemonic"),'Z'));
        exportMultiPostButton.setIcon(SwingUtil.createActionIcon("export"));
        removeIndividualObservationBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editIndividualObservationBatch.action.removeBatch.mnemonic"),'Z'));
        removeIndividualObservationBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeAllIndividualObservationBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editIndividualObservationBatch.action.removeAllBatch.mnemonic"),'Z'));
        removeAllIndividualObservationBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        createIndividualObservationBatchButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.editIndividualObservationBatch.action.createBatch.mnemonic"),'Z'));
        createIndividualObservationBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editIndividualObservationBatchTopPanel, "tutti.editIndividualObservationBatch.help");
        registerHelpId(_broker, importMultiPostButton, "tutti.editIndividualObservationBatch.action.importMultiPost.help");
        registerHelpId(_broker, exportMultiPostButton, "tutti.editIndividualObservationBatch.action.exportMultiPost.help");
        registerHelpId(_broker, removeIndividualObservationBatchMenu, "tutti.editIndividualObservationBatch.action.removeBatch.help");
        registerHelpId(_broker, removeAllIndividualObservationBatchMenu, "tutti.editIndividualObservationBatch.action.removeAllBatch.help");
        registerHelpId(_broker, createIndividualObservationBatchButton, "tutti.editIndividualObservationBatch.action.createBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editIndividualObservationBatchTopPanel", editIndividualObservationBatchTopPanel);
        createModel();
        createValidator();
        createBroker();
        createIndividualObservationBatchTabToolBar();
        createMenu();
        createMenuAction();
        createImportMultiPostButton();
        createExportMultiPostButton();
        createIndividualObservationBatchAttachmentsButton();
        createTablePopup();
        createRemoveIndividualObservationBatchMenu();
        createRemoveAllIndividualObservationBatchMenu();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateIndividualObservationBatchButton();
        createTableScrollPane();
        createTable();
        // inline creation of editIndividualObservationBatchTopPanel
        setName("editIndividualObservationBatchTopPanel");
        setLayout(new BorderLayout());
        editIndividualObservationBatchTopPanel.putClientProperty("help", "tutti.editIndividualObservationBatch.help");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_INDIVIDUAL_OBSERVATION_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeIndividualObservationBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_ALL_INDIVIDUAL_OBSERVATION_BATCH_MENU_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeAllIndividualObservationBatchMenu.setEnabled(model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
    }

}