// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.technical.optimization.grouping;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import fr.ifremer.adagio.core.dao.referential.grouping.Grouping;
import fr.ifremer.adagio.core.dao.referential.grouping.GroupingClassification;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * <html>
 * <head>
 * <style>
 * p {padding:0px; margin:0px;}
 * </style>
 * </head>
 * <body>
 * <p>
 * Table technique, calculé par routine.
 * </p>
 * <p>
 * </p>
 * <p>
 * Permet de lister les navires appartenant à un regroupement (Ex : pour
 * les typologies).
 * </p>
 * <p>
 * </p>
 * <p>
 * L’appartenance d’un navire à un regroupement est définie par une période
 * de validité, et un lieu de validité.
 * </p>
 * <p>
 * </p>
 * <p>
 * La date de fin de la période est optionnelle (si toujours en cours de
 * validité). Le lieu de validité est généralement une zone en mer.
 * </p>
 * </body>
 * </html>
 */
// HibernateEntity.vsl annotations merge-point
public abstract class GroupingVesselHierarchy
    implements Serializable, Comparable<GroupingVesselHierarchy>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 5883160240147664784L;

    // Generate 4 attributes
    private Integer id;

    /**
     * Idenfiant interne. Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Idenfiant interne. Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date startDate;

    /**
     * Début de validité de l'association Navire/Lieu/Regroupement
     * @return this.startDate Date
     */
    public Date getStartDate()
    {
        return this.startDate;
    }

    /**
     * Début de validité de l'association Navire/Lieu/Regroupement
     * @param startDateIn Date
     */
    public void setStartDate(Date startDateIn)
    {
        this.startDate = startDateIn;
    }

    private Date endDate;

    /**
     * Fin  de validité de l'association Group/Navire/Lieu. Optionnelle : si vide, signifie "en
     * cours de validité".
     * @return this.endDate Date
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    /**
     * Fin  de validité de l'association Group/Navire/Lieu. Optionnelle : si vide, signifie "en
     * cours de validité".
     * @param endDateIn Date
     */
    public void setEndDate(Date endDateIn)
    {
        this.endDate = endDateIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 6 associations
    private Grouping grouping;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Un regroupement représente un groupement d'entités (du référentiel ou
     * bien de navires), correspondant à un niveau de regroupement donné (<i>GroupingLevel</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut faire référence à une ou plusieurs entités du
     * référentiel (<i>GroupingItem</i>). Généralement, surtout les
     * regroupements de plus bas niveau sont liés à des entités du référentiel
     * (plus facile à maintenir), puis une table technique remplie toutes les
     * associations possible avec les ancêtres (cf <i>GroupingItemHierarchy</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut avoir un regroupement parent.
     * </p>
     * </body>
     * </html>
     * @return this.grouping Grouping
     */
    public Grouping getGrouping()
    {
        return this.grouping;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Un regroupement représente un groupement d'entités (du référentiel ou
     * bien de navires), correspondant à un niveau de regroupement donné (<i>GroupingLevel</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut faire référence à une ou plusieurs entités du
     * référentiel (<i>GroupingItem</i>). Généralement, surtout les
     * regroupements de plus bas niveau sont liés à des entités du référentiel
     * (plus facile à maintenir), puis une table technique remplie toutes les
     * associations possible avec les ancêtres (cf <i>GroupingItemHierarchy</i>).
     * </p>
     * <p>
     * </p>
     * <p>
     * Un regroupement peut avoir un regroupement parent.
     * </p>
     * </body>
     * </html>
     * @param groupingIn Grouping
     */
    public void setGrouping(Grouping groupingIn)
    {
        this.grouping = groupingIn;
    }

    private Program originProgram;

    /**
     * Programme de collecte à partir duquel le regroupement à été déterminé.
     * @return this.originProgram Program
     */
    public Program getOriginProgram()
    {
        return this.originProgram;
    }

    /**
     * Programme de collecte à partir duquel le regroupement à été déterminé.
     * @param originProgramIn Program
     */
    public void setOriginProgram(Program originProgramIn)
    {
        this.originProgram = originProgramIn;
    }

    private ObjectType originObjectType;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * Type d'objet à l'origine de l'associationdu navire avec le regroupement.
     * </body>
     * </html>
     * @return this.originObjectType ObjectType
     */
    public ObjectType getOriginObjectType()
    {
        return this.originObjectType;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * Type d'objet à l'origine de l'associationdu navire avec le regroupement.
     * </body>
     * </html>
     * @param originObjectTypeIn ObjectType
     */
    public void setOriginObjectType(ObjectType originObjectTypeIn)
    {
        this.originObjectType = originObjectTypeIn;
    }

    private GroupingClassification groupingClassification;

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Une classification de regroupement ne traite que d’un seul type de
     * données du référentiel à la fois (<i>ObjectType</i>).
     * Il peut s’agir de regroupement sur les métiers, les lieux, les espèces,
     * etc.
     * </p>
     * <p>
     * En revanche, un même type de données du référentiel (ex : Métier) peut
     * avoir plusieurs classification de regroupement distinctes (DCR, Ifremer,
     * Natura 2000, …)
     * </p>
     * <p>
     * </p>
     * <p>
     * Une classification de regroupement peut contenir un ou plusieurs niveaux
     * de regroupement (<i>GroupingLevel</i>).
     * </p>
     * </body>
     * </html>
     * @return this.groupingClassification GroupingClassification
     */
    public GroupingClassification getGroupingClassification()
    {
        return this.groupingClassification;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Une classification de regroupement ne traite que d’un seul type de
     * données du référentiel à la fois (<i>ObjectType</i>).
     * Il peut s’agir de regroupement sur les métiers, les lieux, les espèces,
     * etc.
     * </p>
     * <p>
     * En revanche, un même type de données du référentiel (ex : Métier) peut
     * avoir plusieurs classification de regroupement distinctes (DCR, Ifremer,
     * Natura 2000, …)
     * </p>
     * <p>
     * </p>
     * <p>
     * Une classification de regroupement peut contenir un ou plusieurs niveaux
     * de regroupement (<i>GroupingLevel</i>).
     * </p>
     * </body>
     * </html>
     * @param groupingClassificationIn GroupingClassification
     */
    public void setGroupingClassification(GroupingClassification groupingClassificationIn)
    {
        this.groupingClassification = groupingClassificationIn;
    }

    private Location location;

    /**
     * Lieu de validité de l'association Group/Navire. généralement, il s'agit d'une zone en mer.
     * @return this.location Location
     */
    public Location getLocation()
    {
        return this.location;
    }

    /**
     * Lieu de validité de l'association Group/Navire. généralement, il s'agit d'une zone en mer.
     * @param locationIn Location
     */
    public void setLocation(Location locationIn)
    {
        this.location = locationIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    /**
     * Returns <code>true</code> if the argument is an GroupingVesselHierarchy instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof GroupingVesselHierarchy))
        {
            return false;
        }
        final GroupingVesselHierarchy that = (GroupingVesselHierarchy)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link GroupingVesselHierarchy}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link GroupingVesselHierarchy}.
         * @return new GroupingVesselHierarchyImpl()
         */
        public static GroupingVesselHierarchy newInstance()
        {
            return new GroupingVesselHierarchyImpl();
        }

        /**
         * Constructs a new instance of {@link GroupingVesselHierarchy}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param startDate Date
         * @param grouping Grouping
         * @param originProgram Program
         * @param originObjectType ObjectType
         * @param groupingClassification GroupingClassification
         * @param location Location
         * @param vessel Vessel
         * @return newInstance
         */
        public static GroupingVesselHierarchy newInstance(Date startDate, Grouping grouping, Program originProgram, ObjectType originObjectType, GroupingClassification groupingClassification, Location location, Vessel vessel)
        {
            final GroupingVesselHierarchy entity = new GroupingVesselHierarchyImpl();
            entity.setStartDate(startDate);
            entity.setGrouping(grouping);
            entity.setOriginProgram(originProgram);
            entity.setOriginObjectType(originObjectType);
            entity.setGroupingClassification(groupingClassification);
            entity.setLocation(location);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link GroupingVesselHierarchy}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param endDate Date
         * @param updateDate Timestamp
         * @param grouping Grouping
         * @param originProgram Program
         * @param originObjectType ObjectType
         * @param groupingClassification GroupingClassification
         * @param location Location
         * @param vessel Vessel
         * @return newInstance GroupingVesselHierarchy
         */
        public static GroupingVesselHierarchy newInstance(Date startDate, Date endDate, Timestamp updateDate, Grouping grouping, Program originProgram, ObjectType originObjectType, GroupingClassification groupingClassification, Location location, Vessel vessel)
        {
            final GroupingVesselHierarchy entity = new GroupingVesselHierarchyImpl();
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setUpdateDate(updateDate);
            entity.setGrouping(grouping);
            entity.setOriginProgram(originProgram);
            entity.setOriginObjectType(originObjectType);
            entity.setGroupingClassification(groupingClassification);
            entity.setLocation(location);
            entity.setVessel(vessel);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(GroupingVesselHierarchy o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDate().compareTo(o.getStartDate()));
            }
            if (this.getEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDate().compareTo(o.getEndDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// GroupingVesselHierarchy.java merge-point
}