// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.administration.user;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Droit calculé pour un utilisateur à partir d'autres entités implémentant la gestion des droits.
 * S’applique pour un type de donnée, sur une période donnée.
 * Créé d'après l'étude sur l'amélioration des performances V3 (cf. mantis 10528).
 */
// HibernateEntity.vsl annotations merge-point
public abstract class PersonSessionVessel
    implements Serializable, Comparable<PersonSessionVessel>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 7904363713448482514L;

    // Generate 8 attributes
    private Long id;

    /**
     * Identifiant technique
     * @return this.id Long
     */
    public Long getId()
    {
        return this.id;
    }

    /**
     * Identifiant technique
     * @param idIn Long
     */
    public void setId(Long idIn)
    {
        this.id = idIn;
    }

    private Boolean readVessel = Boolean.valueOf(false);

    /**
     * indique le droit de consulter le droit de voir le navire dans l’application cliente (toujours
     * à ‘TRUE’ en v3.2
     * @return this.readVessel Boolean
     */
    public Boolean isReadVessel()
    {
        return this.readVessel;
    }

    /**
     * indique le droit de consulter le droit de voir le navire dans l’application cliente (toujours
     * à ‘TRUE’ en v3.2
     * @param readVesselIn Boolean
     */
    public void setReadVessel(Boolean readVesselIn)
    {
        this.readVessel = readVesselIn;
    }

    private Boolean readData;

    /**
     * indique le droit de consulter les données de type ObjectType en lecture
     * @return this.readData Boolean
     */
    public Boolean isReadData()
    {
        return this.readData;
    }

    /**
     * indique le droit de consulter les données de type ObjectType en lecture
     * @param readDataIn Boolean
     */
    public void setReadData(Boolean readDataIn)
    {
        this.readData = readDataIn;
    }

    private Boolean writeData;

    /**
     * indique le droit de modifier et d’exporter les données de type ObjectType
     * @return this.writeData Boolean
     */
    public Boolean isWriteData()
    {
        return this.writeData;
    }

    /**
     * indique le droit de modifier et d’exporter les données de type ObjectType
     * @param writeDataIn Boolean
     */
    public void setWriteData(Boolean writeDataIn)
    {
        this.writeData = writeDataIn;
    }

    private Boolean validateData;

    /**
     * Indique que l'utilisateur lié à PersonSession à le droit de validation sur les données de
     * type ObjectType, sur la période indiquée et pour le navire et le programme liés.
     * @return this.validateData Boolean
     */
    public Boolean getValidateData()
    {
        return this.validateData;
    }

    /**
     * Indique que l'utilisateur lié à PersonSession à le droit de validation sur les données de
     * type ObjectType, sur la période indiquée et pour le navire et le programme liés.
     * @param validateDataIn Boolean
     */
    public void setValidateData(Boolean validateDataIn)
    {
        this.validateData = validateDataIn;
    }

    private Timestamp startDateTime;

    /**
     * date de début de période d’application du droit calculé
     * @return this.startDateTime Timestamp
     */
    public Timestamp getStartDateTime()
    {
        return this.startDateTime;
    }

    /**
     * date de début de période d’application du droit calculé
     * @param startDateTimeIn Timestamp
     */
    public void setStartDateTime(Timestamp startDateTimeIn)
    {
        this.startDateTime = startDateTimeIn;
    }

    private Timestamp endDateTime;

    /**
     * date de fin d’application du droit calculé. Attribut obligatoire : lorsque la valeur n'est
     * pas renseignée dans les portefeuilles on lui assigne une valeur par défaut supérieure à toute
     * autre date.
     * @return this.endDateTime Timestamp
     */
    public Timestamp getEndDateTime()
    {
        return this.endDateTime;
    }

    /**
     * date de fin d’application du droit calculé. Attribut obligatoire : lorsque la valeur n'est
     * pas renseignée dans les portefeuilles on lui assigne une valeur par défaut supérieure à toute
     * autre date.
     * @param endDateTimeIn Timestamp
     */
    public void setEndDateTime(Timestamp endDateTimeIn)
    {
        this.endDateTime = endDateTimeIn;
    }

    private Timestamp updateDate;

    /**
     * Date de dernière modification en base centrale : utilisé pour la synchronisation entre base
     * locale et base distante
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de dernière modification en base centrale : utilisé pour la synchronisation entre base
     * locale et base distante
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 4 associations
    private PersonSession personSession;

    /**
     * lien vers la tête de grappe (qui porte elle-même le lien vers l’utilisateur pour lequel
     * s’applique le droit calculé)
     * @return this.personSession PersonSession
     */
    public PersonSession getPersonSession()
    {
        return this.personSession;
    }

    /**
     * lien vers la tête de grappe (qui porte elle-même le lien vers l’utilisateur pour lequel
     * s’applique le droit calculé)
     * @param personSessionIn PersonSession
     */
    public void setPersonSession(PersonSession personSessionIn)
    {
        this.personSession = personSessionIn;
    }

    private Vessel vessel;

    /**
     * navire pour lequel s’applique ce droit
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * navire pour lequel s’applique ce droit
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Program program;

    /**
     * programme pour lequel s’applique ce droit
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * programme pour lequel s’applique ce droit
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private ObjectType objectType;

    /**
     * type de donnée sur lequel porte ce droit
     * @return this.objectType ObjectType
     */
    public ObjectType getObjectType()
    {
        return this.objectType;
    }

    /**
     * type de donnée sur lequel porte ce droit
     * @param objectTypeIn ObjectType
     */
    public void setObjectType(ObjectType objectTypeIn)
    {
        this.objectType = objectTypeIn;
    }

    /**
     * Returns <code>true</code> if the argument is an PersonSessionVessel instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof PersonSessionVessel))
        {
            return false;
        }
        final PersonSessionVessel that = (PersonSessionVessel)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link PersonSessionVessel}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link PersonSessionVessel}.
         * @return new PersonSessionVesselImpl()
         */
        public static PersonSessionVessel newInstance()
        {
            return new PersonSessionVesselImpl();
        }

        /**
         * Constructs a new instance of {@link PersonSessionVessel}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param readVessel Boolean
         * @param readData Boolean
         * @param writeData Boolean
         * @param startDateTime Timestamp
         * @param endDateTime Timestamp
         * @param personSession PersonSession
         * @param vessel Vessel
         * @param program Program
         * @param objectType ObjectType
         * @return newInstance
         */
        public static PersonSessionVessel newInstance(Boolean readVessel, Boolean readData, Boolean writeData, Timestamp startDateTime, Timestamp endDateTime, PersonSession personSession, Vessel vessel, Program program, ObjectType objectType)
        {
            final PersonSessionVessel entity = new PersonSessionVesselImpl();
            entity.setReadVessel(readVessel);
            entity.setReadData(readData);
            entity.setWriteData(writeData);
            entity.setStartDateTime(startDateTime);
            entity.setEndDateTime(endDateTime);
            entity.setPersonSession(personSession);
            entity.setVessel(vessel);
            entity.setProgram(program);
            entity.setObjectType(objectType);
            return entity;
        }

        /**
         * Constructs a new instance of {@link PersonSessionVessel}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param readVessel Boolean
         * @param readData Boolean
         * @param writeData Boolean
         * @param validateData Boolean
         * @param startDateTime Timestamp
         * @param endDateTime Timestamp
         * @param updateDate Timestamp
         * @param personSession PersonSession
         * @param vessel Vessel
         * @param program Program
         * @param objectType ObjectType
         * @return newInstance PersonSessionVessel
         */
        public static PersonSessionVessel newInstance(Boolean readVessel, Boolean readData, Boolean writeData, Boolean validateData, Timestamp startDateTime, Timestamp endDateTime, Timestamp updateDate, PersonSession personSession, Vessel vessel, Program program, ObjectType objectType)
        {
            final PersonSessionVessel entity = new PersonSessionVesselImpl();
            entity.setReadVessel(readVessel);
            entity.setReadData(readData);
            entity.setWriteData(writeData);
            entity.setValidateData(validateData);
            entity.setStartDateTime(startDateTime);
            entity.setEndDateTime(endDateTime);
            entity.setUpdateDate(updateDate);
            entity.setPersonSession(personSession);
            entity.setVessel(vessel);
            entity.setProgram(program);
            entity.setObjectType(objectType);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(PersonSessionVessel o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.isReadVessel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isReadVessel().compareTo(o.isReadVessel()));
            }
            if (this.isReadData() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isReadData().compareTo(o.isReadData()));
            }
            if (this.isWriteData() != null)
            {
                cmp = (cmp != 0 ? cmp : this.isWriteData().compareTo(o.isWriteData()));
            }
            if (this.getValidateData() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidateData().compareTo(o.getValidateData()));
            }
            if (this.getStartDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDateTime().compareTo(o.getStartDateTime()));
            }
            if (this.getEndDateTime() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDateTime().compareTo(o.getEndDateTime()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// PersonSessionVessel.java merge-point
}