/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.tree;

import fr.ifremer.tutti.ui.swing.content.genericformat.tree.CruiseSelectTreeNode;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.DataSelectTreeNodeSupport;
import fr.ifremer.tutti.ui.swing.content.genericformat.tree.OperationSelectTreeNode;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.nuiton.i18n.I18n;

public class ImportDataSelectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private final JCheckBox normalCheckBox = new JCheckBox();
    private final JCheckBox partialCheckBox = new JCheckBox();
    private Font normalFont;
    private Font boldFont;

    public ImportDataSelectTreeCellRenderer() {
        Object iconPainter = UIManager.getDefaults().get("CheckBox[Disabled+Selected].iconPainter");
        UIDefaults defaults = new UIDefaults();
        defaults.put("CheckBox[Disabled].iconPainter", iconPainter);
        this.partialCheckBox.putClientProperty("Nimbus.Overrides", defaults);
        this.partialCheckBox.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        this.partialCheckBox.setEnabled(false);
        this.normalFont = UIManager.getFont("CheckBox.font");
        this.boldFont = this.normalFont.deriveFont(1);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        JCheckBox checkBox = this.normalCheckBox;
        if (value != null && value instanceof DataSelectTreeNodeSupport) {
            DataSelectTreeNodeSupport node = (DataSelectTreeNodeSupport)value;
            if (node instanceof CruiseSelectTreeNode) {
                checkBox = this.getCruiseComponent((CruiseSelectTreeNode)node);
            } else if (node instanceof OperationSelectTreeNode) {
                checkBox = this.getOperationComponent((OperationSelectTreeNode)node);
            }
            boolean filled = node.isSelected();
            checkBox.setBackground(label.getBackground());
            checkBox.setForeground(label.getForeground());
            Font font = filled ? this.boldFont : this.normalFont;
            if (node.isExist()) {
                checkBox.setText(checkBox.getText() + " (*)");
                checkBox.setToolTipText(checkBox.getToolTipText() + " (donn\u00e9e existante - identifiant " + node.getOptionalId() + ")");
            }
            checkBox.setFont(font);
            checkBox.setSelected(filled);
        }
        return checkBox;
    }

    protected JCheckBox getCruiseComponent(CruiseSelectTreeNode node) {
        String tip;
        JCheckBox checkBox = this.normalCheckBox;
        String text = I18n.t((String)"tutti.genericformat.import.cruiseNode", (Object[])new Object[]{node.getLabel(), node.getNbChilds()});
        if (node.isSelected()) {
            tip = I18n.t((String)"tutti.genericformat.import.cruiseNode.fullSelected", (Object[])new Object[]{text});
        } else if (node.isPartialSelected()) {
            checkBox = this.partialCheckBox;
            tip = I18n.t((String)"tutti.genericformat.import.cruiseNode.partialSelected", (Object[])new Object[]{text, node.getNbChildSelected()});
        } else {
            tip = text;
        }
        checkBox.setText(text);
        checkBox.setToolTipText(tip);
        return checkBox;
    }

    protected JCheckBox getOperationComponent(OperationSelectTreeNode node) {
        JCheckBox checkBox = this.normalCheckBox;
        String text = I18n.t((String)"tutti.genericformat.import.operationNode", (Object[])new Object[]{node.getLabel()});
        String tip = node.isSelected() ? I18n.t((String)"tutti.genericformat.import.operationNode.selected", (Object[])new Object[]{text, node.getId()}) : text;
        checkBox.setText(text);
        checkBox.setToolTipText(tip);
        return checkBox;
    }
}

