/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential.csv;

import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.referential.csv.PersonRow;
import fr.ifremer.tutti.service.referential.csv.TemporaryReferentialEntityIdParser;
import org.nuiton.csv.ValueParser;
import org.nuiton.i18n.I18n;

public class PersonModel
extends AbstractTuttiImportExportModel<PersonRow> {
    public static PersonModel forExport(char separator) {
        PersonModel exportModel = new PersonModel(separator);
        exportModel.forExport();
        return exportModel;
    }

    public static PersonModel forImport(char separator) {
        PersonModel importModel = new PersonModel(separator);
        importModel.forImport();
        return importModel;
    }

    public PersonRow newEmptyInstance() {
        return new PersonRow();
    }

    protected PersonModel(char separator) {
        super(separator);
    }

    protected void forImport() {
        this.newMandatoryColumn("id", new TemporaryReferentialEntityIdParser(I18n.t((String)"tutti.service.referential.import.person.error.idNotNegative", (Object[])new Object[0])){

            @Override
            protected boolean isTemporaryId(String parse) {
                int id = Integer.parseInt(parse);
                return Persons.isTemporaryId((Integer)id);
            }
        });
        this.newMandatoryColumn("firstName");
        this.newMandatoryColumn("lastName");
        this.newMandatoryColumn("toDelete", (ValueParser)TuttiCsvUtil.BOOLEAN);
    }

    protected void forExport() {
        this.newColumnForExport("id");
        this.newColumnForExport("firstName");
        this.newColumnForExport("lastName");
        this.newColumnForExport("toDelete");
    }
}

