/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatCheckDataService;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class DoCheckWeightAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(DoCheckWeightAction.class);
    private final GenericFormatCheckDataService checkDataService;

    public DoCheckWeightAction(GenericFormatImportContext importContext, GenericFormatCheckDataService checkDataService) {
        super(importContext);
        this.checkDataService = checkDataService;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getImportRequest().isCheckWeights() && this.importContext.isTechnicalFilesValid() && this.importContext.getOperationFileResult().isValid() && this.importContext.getCatchFileResult().isValid() && this.importContext.getMarineLitterFileResult().isValid();
    }

    @Override
    protected void doExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Will check weights.");
        }
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext operationContext : cruiseContext) {
                    progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.checkWeights.fishingOperation", (Object[])new Object[]{cruiseContext.getCruiseLabel(), operationContext.getFishingOperationLabel()}));
                    Set<String> errors = DoCheckWeightAction.this.checkDataService.checkFishingOperation(operationContext.getFishingOperation().getId());
                    operationContext.addCheckErrors(errors);
                }
            }
        });
    }
}

