/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.csv.GearCaracteristicRow;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportCruiseActionSupport;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForGearCaracteristics;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ExportGearCaracteristicAction
extends ExportCruiseActionSupport {
    public ExportGearCaracteristicAction(PersistenceService persistenceService) {
        super(persistenceService);
    }

    @Override
    public void execute(GenericFormatExportContext exportContext, Cruise cruise) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.exportCruise.exportGearCaracteristics", (Object[])new Object[]{cruise.getName()}));
        try {
            CsvProducerForGearCaracteristics producerForGearCaracteristics = exportContext.getProducerForGearCaracteristics();
            ArrayList rows = Lists.newArrayList();
            for (Gear gear : cruise.getGear()) {
                CaracteristicMap caracteristics = this.persistenceService.getGearCaracteristics(cruise.getId(), gear.getId(), gear.getRankOrder());
                Gear gearWithCaracteristics = Gears.newGear((Gear)gear);
                gearWithCaracteristics.setCaracteristics(caracteristics);
                List<GearCaracteristicRow> dataToExport = producerForGearCaracteristics.getDataToExport(cruise, gearWithCaracteristics);
                rows.addAll(dataToExport);
            }
            producerForGearCaracteristics.write(rows);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.genericFormat.export.gearCaracteristics.error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

