/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatResultSupport;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class GenericFormatImportResult
extends GenericFormatResultSupport {
    private static final long serialVersionUID = 1L;
    private final Map<String, GenericFormatImportCruiseResult> cruiseResults = new LinkedHashMap<String, GenericFormatImportCruiseResult>();
    private int nbCruisesCreated;
    private int nbCruisesUpdated;
    private int nbOperationsCreated;
    private int nbOperationsUpdated;
    private boolean withInvalidWeights = false;

    public GenericFormatImportResult(GenericFormatImportContext importContext) {
        super(importContext);
        for (GenericFormatImportCruiseContext cruiseContext : importContext.orderedCruiseContexts()) {
            Cruise cruise = cruiseContext.getCruise();
            GenericFormatImportCruiseResult cruiseResult = new GenericFormatImportCruiseResult(cruiseContext);
            this.cruiseResults.put(cruise.getId(), cruiseResult);
            if (cruiseResult.isOverride()) {
                ++this.nbCruisesUpdated;
            } else {
                ++this.nbCruisesCreated;
            }
            this.nbOperationsCreated += cruiseResult.getNbOperationsCreated();
            this.nbOperationsUpdated += cruiseResult.getNbOperationsUpdated();
            if (!cruiseResult.isWithInvalidWeights()) continue;
            this.withInvalidWeights = true;
        }
    }

    public Collection<GenericFormatImportCruiseResult> getCruiseResults() {
        return this.cruiseResults.values();
    }

    public int getNbCruisesCreated() {
        return this.nbCruisesCreated;
    }

    public int getNbCruisesUpdated() {
        return this.nbCruisesUpdated;
    }

    public int getNbOperationsCreated() {
        return this.nbOperationsCreated;
    }

    public int getNbOperationsUpdated() {
        return this.nbOperationsUpdated;
    }

    public boolean isWithInvalidWeights() {
        return this.withInvalidWeights;
    }
}

