/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.csv.EntityParserFormatterSupport;
import java.util.List;
import java.util.Map;
import org.nuiton.csv.ImportRuntimeException;

public class SpeciesParserFormatter
extends EntityParserFormatterSupport<Species> {
    private final PersistenceService persistenceService;
    private final Map<Integer, Integer> referenceTaxonIdTranslationMap;

    public static SpeciesParserFormatter newFormatter() {
        return new SpeciesParserFormatter(false, null, null);
    }

    public static SpeciesParserFormatter newTechnicalFormatter() {
        return new SpeciesParserFormatter(true, null, null);
    }

    public static SpeciesParserFormatter newParser(PersistenceService persistenceService, Map<Integer, Integer> referenceTaxonIdTranslationMap) {
        return new SpeciesParserFormatter(true, persistenceService, referenceTaxonIdTranslationMap);
    }

    protected SpeciesParserFormatter(boolean technical, PersistenceService persistenceService, Map<Integer, Integer> referenceTaxonIdTranslationMap) {
        super("", technical, Species.class);
        this.persistenceService = persistenceService;
        this.referenceTaxonIdTranslationMap = referenceTaxonIdTranslationMap;
    }

    @Override
    protected List<Species> getEntities() {
        return this.persistenceService.getAllReferentSpecies();
    }

    @Override
    protected Map<String, Species> getEntitiesById() {
        if (this.entitiesById == null) {
            List<Species> entities = this.getEntities();
            this.entitiesById = Speciess.splitReferenceSpeciesByReferenceTaxonId(entities);
        }
        return this.entitiesById;
    }

    @Override
    protected String formatBusiness(Species value) {
        return value.getName();
    }

    @Override
    protected String formatTechnical(Species value) {
        return (String)Speciess.GET_REFERECE_TAXON_ID.apply((Object)value);
    }

    @Override
    protected Species parseNotBlankValue(String value) {
        Integer referenceTaxonId;
        try {
            referenceTaxonId = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ImportRuntimeException("Le format du Code taxon n'est pas valide, cela devrait \u00eatre un entier: " + value);
        }
        if (this.referenceTaxonIdTranslationMap.containsKey(referenceTaxonId)) {
            value = String.valueOf(this.referenceTaxonIdTranslationMap.get(referenceTaxonId));
        }
        return (Species)super.parseNotBlankValue(value);
    }
}

