package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportTemporaryVesselAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.3.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ImportTemporaryVesselAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.referential.ReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n.t;

/**
 * Import temporary vessel referential.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportTemporaryVesselAction extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ImportTemporaryVesselAction.class);

    private File file;

    public ImportTemporaryVesselAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {
            // choose file to import
            file = chooseFile(
                    t("tutti.manageTemporaryReferential.title.choose.importTemporaryVesselFile"),
                    t("tutti.manageTemporaryReferential.action.chooseReferentialVesselFile.import"),
                    "^.*\\.csv", t("tutti.common.file.csv"));

            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull(file);
        if (log.isInfoEnabled()) {
            log.info("Will import vessel temporary " +
                     "referential from file: " + file);
        }

        ReferentialImportExportService service =
                getContext().getTuttiReferentialImportExportService();

        service.importTemporaryVessel(file);

        // reset ui cache
        getDataContext().resetVessels();

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(t("tutti.manageTemporaryReferential.action.chooseReferentialVesselFile.import.success", file));
    }
}