/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.service.UpdateSchemaContextSupport;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.action.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.action.CloseDbAction;
import fr.ifremer.tutti.ui.swing.action.SelectCruiseAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.util.version.Version;

public class ImportDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ImportDbAction.class);
    protected File importFile;
    protected String jdbcUrl;
    protected PersistenceService.ImportStructureType importStructureType;
    private UpdateSchemaContext updateSchemaContext;

    public ImportDbAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"tutti.dbManager.action.importDb.tip", (Object[])new Object[0]));
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
    }

    public boolean prepareAction() throws Exception {
        this.importStructureType = null;
        this.jdbcUrl = null;
        this.updateSchemaContext = null;
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.jdbcUrl = this.getConfig().getJdbcUrl();
            if (this.importFile == null) {
                this.importFile = this.chooseFile(I18n.t((String)"tutti.dbManager.title.choose.dbImportFile", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.chooseDbFile", (Object[])new Object[0]), new String[]{"^.*\\.zip", I18n.t((String)"tutti.common.file.zip", (Object[])new Object[0])});
                if (this.importFile == null) {
                    this.displayWarningMessage(I18n.t((String)"tutti.dbManager.title.choose.dbImportFile", (Object[])new Object[0]), I18n.t((String)"tutti.dbManager.action.importdb.no.import.file.choosen", (Object[])new Object[0]));
                    doAction = false;
                }
            }
            if (doAction) {
                ProgressionModel progressionModel = new ProgressionModel();
                progressionModel.setTotal(3);
                this.setProgressionModel(progressionModel);
                this.importStructureType = this.getContext().getPersistenceService().checkImportStructure(this.importFile);
            }
        }
        return doAction;
    }

    public void releaseAction() {
        this.importFile = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        String message;
        Preconditions.checkNotNull((Object)this.importFile);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import db: " + this.importFile));
        }
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments(I18n.t((String)"tutti.importDb.step.unzipArchive", (Object[])new Object[0]));
        this.getContext().getPersistenceService().importDb(this.importStructureType, this.importFile);
        progressionModel.increments(I18n.t((String)"tutti.importDb.step.openDb", (Object[])new Object[]{this.jdbcUrl}));
        try {
            this.getContext().setDbExist(true);
            this.getContext().openPersistenceService();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not open db", (Throwable)e);
            }
            this.getContext().closePersistenceService();
            throw new ApplicationBusinessException(I18n.t((String)"tutti.dbManager.action.importdb.couldNotOpen", (Object[])new Object[0]), (Throwable)e);
        }
        progressionModel.increments(I18n.t((String)"tutti.importDb.step.checkSchemaVersion", (Object[])new Object[0]));
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        this.updateSchemaContext = new UpdateSchemaContext();
        persistenceService.prepareUpdateSchemaContext((UpdateSchemaContextSupport)this.updateSchemaContext);
        Version schemaVersion = this.updateSchemaContext.getSchemaVersion();
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected database version: " + schemaVersion));
        }
        Version schemaVersionIfUpdate = this.updateSchemaContext.getSchemaVersionIfUpdate();
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected schema application version:" + schemaVersionIfUpdate));
        }
        if (this.updateSchemaContext.isCloseDb()) {
            progressionModel.increments(I18n.t((String)"tutti.importDb.step.closeDb", (Object[])new Object[0]));
            this.getActionEngine().runInternalAction(this.handler, CloseDbAction.class);
            return;
        }
        if (this.updateSchemaContext.isWillUpdate()) {
            progressionModel.adaptTotal(progressionModel.getTotal() + 2);
            message = I18n.t((String)"tutti.importDb.step.will.migrateSchema", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate});
            progressionModel.increments(message);
            this.sendMessage(message);
            this.getContext().getPersistenceService().updateSchema();
            this.sendMessage(I18n.t((String)"tutti.flash.info.db.schema.updated", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate}));
        }
        message = I18n.t((String)"tutti.importDb.step.check.dbContext", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate});
        progressionModel.increments(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Check db context");
        }
        this.getContext().checkDbContext();
        this.getActionEngine().runInternalAction(this.handler, SelectCruiseAction.class);
    }

    public void postSuccessAction() {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        super.postSuccessAction();
        if (this.updateSchemaContext.isCloseDb()) {
            this.sendMessage(I18n.t((String)"tutti.flash.info.db.imported.but.closed", (Object[])new Object[]{this.jdbcUrl}));
        } else {
            this.sendMessage(I18n.t((String)"tutti.flash.info.db.imported", (Object[])new Object[]{this.jdbcUrl}));
        }
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }

    public void postFailedAction(Throwable error) {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        super.postFailedAction(error);
    }

    public class UpdateSchemaContext
    extends UpdateSchemaContextSupport {
        private boolean closeDb;

        public void init(Version schemaVersion, Version schemaVersionIfUpdate) {
            super.init(schemaVersion, schemaVersionIfUpdate);
            if (this.isSchemaVersionTooHigh()) {
                boolean continueAction;
                String message = I18n.t((String)"tutti.dbManager.action.upgradeDb.schema.too.high", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate});
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n.t((String)"tutti.dbManager.action.upgradeDb.schema.too.high.help", (Object[])new Object[0]));
                int i = JOptionPane.showConfirmDialog(((MainUIHandler)ImportDbAction.this.handler).getTopestUI(), htmlMessage, I18n.t((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), 2, 3);
                boolean bl = continueAction = i == 0;
                if (!continueAction) {
                    this.closeDb = true;
                }
            }
        }

        protected boolean askUserToMigrate(Version schemaVersion, Version schemaVersionIfUpdate) {
            boolean continueAction;
            String message = I18n.t((String)"tutti.dbManager.action.upgradeDb.schema.to.update.message", (Object[])new Object[]{schemaVersion, schemaVersionIfUpdate});
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n.t((String)"tutti.dbManager.action.upgradeDb.schema.to.update.message.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(((MainUIHandler)ImportDbAction.this.handler).getTopestUI(), htmlMessage, I18n.t((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), 2, 3);
            boolean bl = continueAction = i == 0;
            if (continueAction) {
                continueAction = true;
            } else {
                this.closeDb = true;
            }
            return continueAction;
        }

        public boolean isCloseDb() {
            return this.closeDb;
        }
    }
}

