/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.hibernate;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

public class TemporaryDataHelper {
    public static final String TEMPORARY_NAME_PREFIX = "#TEMP\u00bf";

    public static <T> T getNewNegativeIdForTemporaryData(Session session, Class<? extends Serializable> entityClass) throws HibernateException {
        String entityName = entityClass.getSimpleName();
        if (!entityName.endsWith("Impl")) {
            entityName = entityName + "Impl";
        }
        Query query = session.createQuery("SELECT coalesce(min(id),0) - 1 FROM " + entityName + " WHERE id <= 0");
        Object result = query.uniqueResult();
        return (T)result;
    }

    public static String removeTemporaryNamePrefix(String code) {
        if (code != null && code.startsWith(TEMPORARY_NAME_PREFIX)) {
            return code.substring(TEMPORARY_NAME_PREFIX.length());
        }
        return code;
    }

    public static String replaceTemporaryNamePrefix(String code, String replacement) {
        if (code != null && code.startsWith(TEMPORARY_NAME_PREFIX)) {
            return replacement + code.substring(TEMPORARY_NAME_PREFIX.length());
        }
        return code;
    }

    public static String getTemporaryLabelFromNegativeId(int negativeId) throws HibernateException {
        Preconditions.checkArgument((negativeId < 0 ? 1 : 0) != 0);
        return TEMPORARY_NAME_PREFIX + Integer.toString(-1 * negativeId);
    }

    public static boolean isTemporaryId(Number id) {
        return id != null && id.intValue() < 0;
    }

    public static boolean isTemporaryCode(String code) {
        return code != null && code.startsWith(TEMPORARY_NAME_PREFIX);
    }
}

