/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.action.ImportMultiPostActionSupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class ImportMultiPostSpeciesAction
extends ImportMultiPostActionSupport<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    public ImportMultiPostSpeciesAction(SpeciesBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiSpecies";
    }

    @Override
    protected String getFileExtensionDescription() {
        return I18n.t((String)"tutti.common.file.tuttiSpecies", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserTitle() {
        return I18n.t((String)"tutti.editSpeciesBatch.action.importMultiPost.sourceFile.title", (Object[])new Object[0]);
    }

    @Override
    protected String getFileChooserButton() {
        return I18n.t((String)"tutti.editSpeciesBatch.action.importMultiPost.sourceFile.button", (Object[])new Object[0]);
    }

    @Override
    protected String getSuccessMessage(File file) {
        return I18n.t((String)"tutti.editSpeciesBatch.action.importMultiPost.success", (Object[])new Object[]{file});
    }

    @Override
    protected Map<String, Object> importBatches(MultiPostImportService multiPostImportExportService, File file, FishingOperation operation) {
        Map notImportedData = multiPostImportExportService.importSpecies(file, operation);
        return notImportedData;
    }

    @Override
    protected String buildNotImportedDataReportText(Map<String, Object> notImportedData) {
        WeightUnit speciesWeightUnit = this.getConfig().getSpeciesWeightUnit();
        StringBuilder builder = new StringBuilder();
        Float totalSortedWeight = (Float)notImportedData.get("speciesTotalSortedWeight");
        this.addNotImportedWeightToReport(builder, totalSortedWeight, speciesWeightUnit, I18n.n((String)"tutti.multiPostImportLog.totalSortedWeight", (Object[])new Object[0]));
        Float inertWeight = (Float)notImportedData.get("speciesTotalInertWeight");
        this.addNotImportedWeightToReport(builder, inertWeight, speciesWeightUnit, I18n.n((String)"tutti.multiPostImportLog.inertWeight", (Object[])new Object[0]));
        Float livingNotItemizedWeight = (Float)notImportedData.get("speciesTotalLivingNotItemizedWeight");
        this.addNotImportedWeightToReport(builder, livingNotItemizedWeight, speciesWeightUnit, I18n.n((String)"tutti.multiPostImportLog.livingNotItemizedWeight", (Object[])new Object[0]));
        Collection notImportedSpeciesBatches = (Collection)notImportedData.get("batchesKey");
        for (SpeciesBatch sb : notImportedSpeciesBatches) {
            builder.append("- ").append(this.decorate(sb.getSpecies())).append(" / ").append(this.decorate(sb.getSampleCategoryValue())).append("\n");
        }
        return builder.toString();
    }
}

