/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapCellComponent;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnUIHandler;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.CaracteristicColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.validator.NuitonValidatorResult;

public class IndividualObservationBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<IndividualObservationBatchRowModel, IndividualObservationBatchUIModel, IndividualObservationBatchUI>
implements CaracteristicMapColumnUIHandler {
    private static final Log log = LogFactory.getLog(IndividualObservationBatchUIHandler.class);
    protected ValidationService validationService = this.getContext().getValidationService();
    protected final WeightUnit weightUnit = this.getConfig().getIndividualObservationWeightUnit();

    public IndividualObservationBatchUIHandler(TuttiUI<?, ?> parentUi, IndividualObservationBatchUI ui) {
        super(parentUi, ui, "species", "weight", "size", "lengthStepCaracteristic", "caracteristics", "defaultCaracteristics", "comment", "attachment");
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        IndividualObservationBatchUIModel model = (IndividualObservationBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get individualObservation batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((TuttiEntity)bean)) {
                List batches = this.persistenceService.getAllIndividualObservationBatch(bean.getId());
                for (IndividualObservationBatch aBatch : batches) {
                    List speciesList;
                    int i;
                    if (this.getDataContext().isProtocolFilled() && (i = (speciesList = this.getDataContext().getReferentSpeciesWithSurveyCode()).indexOf(aBatch.getSpecies())) > -1) {
                        aBatch.setSpecies((Species)speciesList.get(i));
                    }
                    IndividualObservationBatchRowModel entry = this.loadBatch(aBatch);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
        this.recomputeBatchActionEnable();
    }

    protected IndividualObservationBatchRowModel loadBatch(IndividualObservationBatch aBatch) {
        IndividualObservationBatchRowModel newRow = new IndividualObservationBatchRowModel(this.weightUnit, aBatch, ((IndividualObservationBatchUIModel)this.getModel()).getDefaultCaracteristic());
        List attachments = this.persistenceService.getAllAttachments(newRow.getObjectType(), newRow.getObjectId());
        newRow.addAllAttachment(attachments);
        return newRow;
    }

    public IndividualObservationBatchTableModel getTableModel() {
        return (IndividualObservationBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((IndividualObservationBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(IndividualObservationBatchRowModel row) {
        IndividualObservationBatch batch = (IndividualObservationBatch)row.toBean();
        NuitonValidatorResult validator = this.validationService.validateIndividualObservationBatch(batch);
        boolean result = !validator.hasErrorMessagess();
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, IndividualObservationBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        this.saveSelectedRowIfNeeded();
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<IndividualObservationBatchRowModel> rowMonitor, IndividualObservationBatchRowModel row) {
        if (row != null && row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + row + " was modified, will save it"));
            }
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, IndividualObservationBatchRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, IndividualObservationBatchRowModel oldRow, int newRowIndex, IndividualObservationBatchRowModel newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{IndividualObservationBatchTableModel.COMMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String value = (String)adapter.getValue();
                return StringUtils.isNotBlank((CharSequence)value);
            }
        }}), cellWithValueColor);
        table.addHighlighter(commentHighlighter);
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{IndividualObservationBatchTableModel.ATTACHMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Collection attachments = (Collection)adapter.getValue();
                return CollectionUtils.isNotEmpty((Collection)attachments);
            }
        }}), cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
    }

    @Override
    public SwingValidator<IndividualObservationBatchUIModel> getValidator() {
        return ((IndividualObservationBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + this.ui));
        }
        List defaultCaracteristic = this.getDataContext().getDefaultIndividualObservationCaracteristics();
        EditCatchesUIModel catchesUIModel = ((IndividualObservationBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        IndividualObservationBatchUIModel model = new IndividualObservationBatchUIModel(catchesUIModel, defaultCaracteristic);
        ((IndividualObservationBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<Caracteristic> caracteristicDecorator = this.getDecorator(Caracteristic.class, "parameterOnlyWithUnit");
        Decorator<Caracteristic> caracteristicTipDecorator = this.getDecorator(Caracteristic.class, "withUnit");
        Decorator<CaracteristicQualitativeValue> caracteristicQualitativeDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Decorator<Species> speciesDecorator = this.getDecorator(Species.class, "fromProtocol");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.SPECIES, speciesDecorator, this.getDataContext().getReferentSpeciesWithSurveyCode());
        this.addFloatColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.WEIGHT, this.weightUnit);
        this.addFloatColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.SIZE, "\\d{0,6}(\\.\\d{0,3})?");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, IndividualObservationBatchTableModel.LENGTH_STEP_CARACTERISTIC, this.getDecorator(Caracteristic.class, null), this.getDataContext().getLengthStepCaracteristics());
        List<Caracteristic> defaultCaracteristic = ((IndividualObservationBatchUIModel)this.getModel()).getDefaultCaracteristic();
        for (Caracteristic caracteristic : defaultCaracteristic) {
            String header = caracteristicDecorator.toString((Object)caracteristic);
            String headerTip = caracteristicTipDecorator.toString((Object)caracteristic);
            CaracteristicColumnIdentifier id = CaracteristicColumnIdentifier.newCaracteristicId(caracteristic, "defaultCaracteristics", header, headerTip);
            switch (caracteristic.getCaracteristicType()) {
                case NUMBER: {
                    this.addFloatColumnToModel((TableColumnModel)columnModel, id, "\\d{0,6}(\\.\\d{0,3})?");
                    break;
                }
                case QUALITATIVE: {
                    List values = caracteristic.getQualitativeValue();
                    this.addComboDataColumnToModel((TableColumnModel)columnModel, id, caracteristicQualitativeDecorator, values);
                    break;
                }
                case TEXT: {
                    this.addColumnToModel((TableColumnModel)columnModel, id);
                }
            }
        }
        Set<Caracteristic> caracteristicsToSkip = Collections.unmodifiableSet(Sets.newHashSet(((IndividualObservationBatchUIModel)this.getModel()).getDefaultCaracteristic()));
        this.addColumnToModel((TableColumnModel)columnModel, CaracteristicMapCellComponent.newEditor(this.ui, caracteristicsToSkip), CaracteristicMapCellComponent.newRender(this.getContext()), IndividualObservationBatchTableModel.OTHER_CARACTERISTICS);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(this.ui), CommentCellRenderer.newRender(), IndividualObservationBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), IndividualObservationBatchTableModel.ATTACHMENT);
        IndividualObservationBatchTableModel tableModel = new IndividualObservationBatchTableModel(this.weightUnit, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
        this.recomputeBatchActionEnable();
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((IndividualObservationBatchUI)this.getUI()).getTable();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
    }

    @Override
    public CaracteristicMapEditorUI getCaracteristicMapEditor() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        return parent.getIndividualObservationCaracteristicMapEditor();
    }

    @Override
    public void showCaracteristicMapEditor(Species species) {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard("caracteristicsCard", species);
    }

    @Override
    public void hideCaracteristicMapEditor() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard("main");
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        CreateIndividualObservationBatchUI createBatchEditor = parent.getIndividualObservationTabCreateBatch();
        createBatchEditor.getHandler().openUI((IndividualObservationBatchUIModel)this.getModel());
        parent.getHandler().setIndividualObservationSelectedCard("createBatch");
    }

    public void addBatch(CreateIndividualObservationBatchUIModel model) {
        if (model.isValid()) {
            IndividualObservationBatchTableModel tableModel = this.getTableModel();
            IndividualObservationBatchRowModel newRow = tableModel.createNewRow();
            newRow.setSpecies(model.getSpecies());
            newRow.setWeight(model.getWeight());
            newRow.setSize(model.getSize());
            newRow.setLengthStepCaracteristic(model.getLengthStepCaracteristic());
            newRow.getDefaultCaracteristics().putAll((Map)model.getCaracteristics());
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            tableModel.addNewRow(newRow);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), tableModel.getRowCount() - 1, 0);
        }
        this.recomputeBatchActionEnable();
    }

    protected void recomputeBatchActionEnable() {
        int rowIndex = this.getTable().getSelectedRow();
        boolean enableRemove = false;
        if (rowIndex != -1) {
            enableRemove = true;
        }
        IndividualObservationBatchUIModel model = (IndividualObservationBatchUIModel)this.getModel();
        model.setRemoveBatchEnabled(enableRemove);
    }

    protected void saveRow(IndividualObservationBatchRowModel row) {
        Serializable value;
        IndividualObservationBatch entityToSave = row.toEntity();
        CaracteristicMap caracteristics = new CaracteristicMap();
        entityToSave.setCaracteristics(caracteristics);
        for (Map.Entry entry : row.getCaracteristics().entrySet()) {
            value = (Serializable)entry.getValue();
            if (value == null) continue;
            caracteristics.put(entry.getKey(), (Object)value);
        }
        for (Map.Entry entry : row.getDefaultCaracteristics().entrySet()) {
            value = (Serializable)entry.getValue();
            if (value == null) continue;
            caracteristics.put(entry.getKey(), (Object)value);
        }
        FishingOperation fishingOperation = ((IndividualObservationBatchUIModel)this.getModel()).getFishingOperation();
        entityToSave.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew((TuttiEntity)entityToSave)) {
            entityToSave = this.persistenceService.createIndividualObservationBatch(entityToSave);
            row.setId(entityToSave.getId());
        } else {
            this.persistenceService.saveIndividualObservationBatch(entityToSave);
        }
        ((IndividualObservationBatchUIModel)this.getModel()).fireBatchUpdated(row);
    }
}

