/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.syntax;

import org.andromda.core.translation.TranslationUtils;

public class OCLFeatures {
    private static final String ALL_INSTANCES = "(\\s*\\w*\\s*(\\w+|::)*)?\\s*allInstances\\s*\\(\\s*\\)";
    private static final String OCL_IS_KIND_OF = "oclIsKindOf\\s*\\(\\s*[\\w+|::]+\\s*\\)\\s*";
    private static final String OCL_IS_TYPE_OF = "oclIsTypeOf\\s*\\(\\s*[\\w+|::]+\\s*\\)\\s*";
    private static final String CONCAT = "concat\\s*\\(\\s*[\\w*[\\.]*]+\\s*\\)\\s*";
    private static final String ALL_PATTERNS = "(\\s*\\w*\\s*(\\w+|::)*)?\\s*allInstances\\s*\\(\\s*\\)|oclIsKindOf\\s*\\(\\s*[\\w+|::]+\\s*\\)\\s*|oclIsTypeOf\\s*\\(\\s*[\\w+|::]+\\s*\\)\\s*|concat\\s*\\(\\s*[\\w*[\\.]*]+\\s*\\)\\s*";
    private static final String SELF = "self";

    public static boolean isAllInstances(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(ALL_INSTANCES);
    }

    public static boolean isConcat(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(CONCAT);
    }

    public static boolean isOclIsTypeOf(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(OCL_IS_TYPE_OF);
    }

    public static boolean isOclIsKindOf(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(OCL_IS_KIND_OF);
    }

    public static boolean isOclFeature(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(ALL_PATTERNS);
    }

    public static boolean isSelf(Object expression) {
        return TranslationUtils.deleteWhitespace((Object)expression).matches(SELF);
    }
}

